/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import open.dolphin.log.LogWriter;

public class DateExpire {
    public static final String ORCA_DATE_FORMAT = "yyyyMMdd";
    public static final String ORCA_BEGIN_TOKEN = "00000000";
    public static final String ORCA_FINAL_TOKEN = "99999999";
    public static final String BEGIN_DATE = "20000101";
    public static final String FINAL_DATE = "20200101";

    public static boolean expire(String startDate, String endDate) {
        return DateExpire.expire(new Date(), startDate, endDate);
    }

    public static int expireState(GregorianCalendar gc, String startDate, String endDate) {
        if (endDate != null && !endDate.isEmpty()) {
            SimpleDateFormat f = new SimpleDateFormat(ORCA_DATE_FORMAT);
            String refDate = f.format(gc.getTime()).toString();
            if (startDate != null && refDate.compareTo(startDate) < 0) {
                return 0;
            }
            if (refDate.compareTo(endDate) > 0) {
                return 2;
            }
        }
        return 1;
    }

    public static boolean expire(Date now, String startDate, String endDate) {
        try {
            if (startDate != null || endDate != null) {
                SimpleDateFormat orcaDateFormat = new SimpleDateFormat(ORCA_DATE_FORMAT);
                Date start = orcaDateFormat.parse(startDate.equals(ORCA_BEGIN_TOKEN) ? BEGIN_DATE : startDate);
                Date end = orcaDateFormat.parse(endDate.equals(ORCA_FINAL_TOKEN) ? FINAL_DATE : endDate);
                return DateExpire.expire(now, start, end);
            }
        }
        catch (ParseException ex) {
            LogWriter.error("DateExpire", "");
        }
        return false;
    }

    public static boolean expire(Date now, Date startDate, Date endDate) {
        int s = startDate.compareTo(now);
        int e = endDate.compareTo(now);
        if (s > 0) {
            return true;
        }
        return e < 0;
    }

    public static int compare(String startDate, String endDate) {
        return DateExpire.compare(new Date(), startDate, endDate);
    }

    public static int compare(Date now, String startDate, String endDate) {
        try {
            if (startDate != null && endDate != null) {
                SimpleDateFormat orcaDateFormat = new SimpleDateFormat(ORCA_DATE_FORMAT);
                Date start = orcaDateFormat.parse(startDate.equals(ORCA_BEGIN_TOKEN) ? BEGIN_DATE : startDate);
                Date end = orcaDateFormat.parse(endDate.equals(ORCA_FINAL_TOKEN) ? FINAL_DATE : endDate);
                return DateExpire.compare(now, start, end);
            }
        }
        catch (ParseException ex) {
            LogWriter.error("", "");
        }
        return -1;
    }

    public static int compare(Date now, Date startDate, Date endDate) {
        if (now.compareTo(startDate) < 0) {
            return -1;
        }
        if (now.compareTo(endDate) > 0) {
            return 1;
        }
        return 0;
    }
}

