/*
 * Decompiled with CFR 0.152.
 */
package open.dolphin.helper;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import open.dolphin.project.GlobalConstants;

public class StripeRenderer
extends DefaultListCellRenderer {
    private static final Color DEFAULT_ODD_COLOR = GlobalConstants.getColor("color.odd");
    private static final Color DEFAULT_EVENN_COLOR = GlobalConstants.getColor("color.even");
    private Color oddColor;
    private Color evenColor;

    public StripeRenderer() {
        this(DEFAULT_ODD_COLOR, DEFAULT_EVENN_COLOR);
    }

    public StripeRenderer(Color oddColor, Color evenColor) {
        this.setOpaque(true);
        this.setOddColor(oddColor);
        this.setEvenColor(evenColor);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setForeground(list.getForeground());
            if (index % 2 == 0) {
                this.setBackground(this.getEvenColor());
            } else {
                this.setBackground(this.getOddColor());
            }
        }
        return label;
    }

    public void setOddColor(Color oddColor) {
        this.oddColor = oddColor;
    }

    public Color getOddColor() {
        return this.oddColor;
    }

    public void setEvenColor(Color evenColor) {
        this.evenColor = evenColor;
    }

    public Color getEvenColor() {
        return this.evenColor;
    }
}

