/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.dict;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.UIDDictionary;
import org.dcm4cheri.dict.TagDictionaryImpl;
import org.dcm4cheri.dict.UIDDictionaryImpl;

public class DictionaryFactoryImpl
extends DictionaryFactory {
    private static final String DEF_TAG_DICT = "org/dcm4cheri/dict/TagDictionary.ser";
    private static final String DEF_UID_DICT = "org/dcm4cheri/dict/UIDDictionary.ser";
    private static TagDictionary defTagDict;
    private static UIDDictionary defUIDDict;

    public TagDictionary newTagDictionary() {
        return new TagDictionaryImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TagDictionary getDefaultTagDictionary() {
        if (defTagDict != null) {
            return defTagDict;
        }
        DictionaryFactoryImpl dictionaryFactoryImpl = this;
        synchronized (dictionaryFactoryImpl) {
            TagDictionary tagDictionary;
            if (defTagDict != null) {
                return defTagDict;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream in = loader.getResourceAsStream(DEF_TAG_DICT);
            if (in == null) {
                throw new RuntimeException("Missing org/dcm4cheri/dict/TagDictionary.ser");
            }
            InputStream ois = null;
            try {
                ois = new ObjectInputStream(new BufferedInputStream(in));
                tagDictionary = defTagDict = (TagDictionary)((ObjectInputStream)ois).readObject();
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Load DefaultTagDictionary from org/dcm4cheri/dict/TagDictionary.ser failed!", ex);
                }
                catch (Throwable throwable) {
                    try {
                        (ois != null ? ois : in).close();
                        throw throwable;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                (ois != null ? ois : in).close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return tagDictionary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initDefTagDict(File xmlFile, File serFile) throws Exception {
        TagDictionaryImpl dict = new TagDictionaryImpl();
        dict.load(xmlFile);
        serFile.getParentFile().mkdirs();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serFile)));
        try {
            oos.writeObject(dict);
            System.out.println("Create: " + serFile);
        }
        finally {
            oos.close();
        }
    }

    public UIDDictionary newUIDDictionary() {
        return new UIDDictionaryImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UIDDictionary getDefaultUIDDictionary() {
        if (defUIDDict != null) {
            return defUIDDict;
        }
        DictionaryFactoryImpl dictionaryFactoryImpl = this;
        synchronized (dictionaryFactoryImpl) {
            UIDDictionary uIDDictionary;
            if (defUIDDict != null) {
                return defUIDDict;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream in = loader.getResourceAsStream(DEF_UID_DICT);
            if (in == null) {
                throw new RuntimeException("Missing org/dcm4cheri/dict/UIDDictionary.ser");
            }
            InputStream ois = null;
            try {
                ois = new ObjectInputStream(new BufferedInputStream(in));
                uIDDictionary = defUIDDict = (UIDDictionary)((ObjectInputStream)ois).readObject();
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Load DefaultUIDDictionary from org/dcm4cheri/dict/UIDDictionary.ser failed!", ex);
                }
                catch (Throwable throwable) {
                    try {
                        (ois != null ? ois : in).close();
                        throw throwable;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                (ois != null ? ois : in).close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return uIDDictionary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initDefUIDDict(File xmlFile, File serFile) throws Exception {
        UIDDictionaryImpl dict = new UIDDictionaryImpl();
        dict.load(xmlFile);
        serFile.getParentFile().mkdirs();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serFile)));
        try {
            oos.writeObject(dict);
            System.out.println("Create: " + serFile);
        }
        finally {
            oos.close();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: java -cp <classpath> org/dcm4cheri/dict/DictionaryFactoryImpl \\\n  <dictionary.xml> <resdir>");
            System.exit(1);
        }
        File resdir = new File(args[1]);
        DictionaryFactoryImpl.initDefTagDict(new File(args[0]), new File(resdir, DEF_TAG_DICT));
        DictionaryFactoryImpl.initDefUIDDict(new File(args[0]), new File(resdir, DEF_UID_DICT));
    }
}

