/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4cheri.data;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.InflaterInputStream;
import javax.imageio.stream.ImageInputStream;
import org.apache.log4j.Logger;
import org.dcm4che.data.DcmDecodeParam;
import org.dcm4che.data.DcmHandler;
import org.dcm4che.data.DcmParseException;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.FileFormat;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.Tags;
import org.dcm4che.dict.VRMap;
import org.dcm4che.dict.VRs;
import org.dcm4cheri.data.DcmHandlerAdapter;
import org.dcm4cheri.data.DcmHandlerAdapter2;
import org.dcm4cheri.data.InputStreamAdapter;
import org.xml.sax.ContentHandler;

final class DcmParserImpl
implements DcmParser {
    private static final Logger log = Logger.getLogger(DcmParserImpl.class);
    private static final int MGLIB_MAGIC = 1296123721;
    private static final int TS_ID_TAG = 131088;
    private static final int ITEM_TAG = -73728;
    private static final int ITEM_DELIMITATION_ITEM_TAG = -73715;
    private static final int SEQ_DELIMITATION_ITEM_TAG = -73507;
    private final byte[] b0 = new byte[0];
    private final byte[] b12 = new byte[12];
    private final ByteBuffer bb12 = ByteBuffer.wrap(this.b12).order(ByteOrder.LITTLE_ENDIAN);
    private DcmDecodeParam decodeParam = DcmDecodeParam.IVR_LE;
    private DataInput in = null;
    private DcmHandler handler = null;
    private VRMap vrMap = VRMap.DEFAULT;
    private int rTag = -1;
    private int rVR = -1;
    private int rLen = -1;
    private long rPos = 0L;
    private int hLen = -1;
    private boolean readHeader = true;
    private boolean eof = false;
    private String tsUID = null;
    private ByteArrayOutputStream unBuf = null;

    public DcmParserImpl(InputStream in) {
        this.in = in instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
    }

    public DcmParserImpl(ImageInputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = in;
    }

    public InputStream getInputStream() {
        return (InputStream)((Object)this.in);
    }

    public ImageInputStream getImageInputStream() {
        return (ImageInputStream)this.in;
    }

    public final int getReadTag() {
        return this.rTag;
    }

    public final int getReadVR() {
        return this.rVR;
    }

    public final int getReadLength() {
        return this.rLen;
    }

    public final long getStreamPosition() {
        return this.rPos;
    }

    public final void setStreamPosition(long rPos) {
        this.rPos = rPos;
    }

    public final void seek(long pos) throws IOException {
        if (!(this.in instanceof ImageInputStream)) {
            throw new UnsupportedOperationException();
        }
        ((ImageInputStream)this.in).seek(pos);
        this.rPos = pos;
    }

    public final boolean hasSeenEOF() {
        return this.eof;
    }

    public final void setDcmHandler(DcmHandler handler) {
        this.handler = handler;
    }

    public final void setSAXHandler(ContentHandler hc, TagDictionary dict) {
        this.handler = new DcmHandlerAdapter(hc, dict);
    }

    public final void setSAXHandler2(ContentHandler ch, TagDictionary dict, int[] excludeTags, int excludeValueLengthLimit, File basedir) {
        this.handler = new DcmHandlerAdapter2(ch, dict, excludeTags, excludeValueLengthLimit, basedir);
    }

    public final void setVRMap(VRMap vrMap) {
        if (vrMap == null) {
            throw new NullPointerException();
        }
        this.vrMap = vrMap;
    }

    public final void setDcmDecodeParam(DcmDecodeParam param) {
        if (log.isDebugEnabled()) {
            log.debug(param.toString());
        }
        if (param.deflated != this.decodeParam.deflated) {
            if (!param.deflated) {
                throw new UnsupportedOperationException("Cannot remove Inflater");
            }
            this.in = new DataInputStream(new InflaterInputStream(this.in instanceof InputStream ? (InputStream)((Object)this.in) : new InputStreamAdapter((ImageInputStream)this.in)));
        }
        this.bb12.order(param.byteOrder);
        this.decodeParam = param;
    }

    public final DcmDecodeParam getDcmDecodeParam() {
        return this.decodeParam;
    }

    private String logMsg() {
        return "rPos:" + this.rPos + " " + Tags.toString(this.rTag) + " " + VRs.toString(this.rVR) + " #" + this.rLen;
    }

    public FileFormat detectFileFormat() throws IOException {
        FileFormat retval = null;
        if (this.in instanceof DataInputStream) {
            retval = this.detectFileFormat((DataInputStream)this.in);
        } else if (this.in instanceof ImageInputStream) {
            retval = this.detectFileFormat((ImageInputStream)this.in);
        } else {
            throw new UnsupportedOperationException("" + this.in);
        }
        if (log.isDebugEnabled()) {
            log.debug("detect " + retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileFormat detectFileFormat(DataInputStream in) throws IOException {
        in.mark(132);
        byte[] b = new byte[132];
        try {
            in.readFully(b, 0, 132);
            if (b[128] == 68 && b[129] == 73 && b[130] == 67 && b[131] == 77) {
                FileFormat fileFormat = FileFormat.DICOM_FILE;
                return fileFormat;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            in.reset();
        }
        return this.detectFileFormat(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileFormat detectFileFormat(ImageInputStream in) throws IOException {
        in.mark();
        byte[] b = new byte[132];
        try {
            in.readFully(b, 0, 132);
            if (b[128] == 68 && b[129] == 73 && b[130] == 67 && b[131] == 77) {
                FileFormat fileFormat = FileFormat.DICOM_FILE;
                return fileFormat;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            in.reset();
        }
        return this.detectFileFormat(b);
    }

    private FileFormat detectFileFormat(byte[] b) throws DcmParseException {
        int len;
        int tag;
        boolean bigEndian = b[1] != 0;
        int n = tag = bigEndian ? (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF : (b[1] & 0xFF) << 24 | (b[0] & 0xFF) << 16 | (b[3] & 0xFF) << 8 | b[2] & 0xFF;
        if (tag == 1296123721) {
            return FileFormat.MGLIB;
        }
        boolean fmi = (tag & 0xFFFF0000) == 131072;
        int vr = (b[4] & 0xFF) << 8 | b[5] & 0xFF;
        if (VRMap.DEFAULT.lookup(tag) == vr) {
            return fmi ? (bigEndian ? FileFormat.EVR_BE_FILE_WO_PREAMBLE : FileFormat.DICOM_FILE_WO_PREAMBLE) : (bigEndian ? FileFormat.EVR_BE_STREAM : FileFormat.EVR_LE_STREAM);
        }
        int n2 = len = bigEndian ? (b[4] & 0xFF) << 24 | (b[5] & 0xFF) << 16 | (b[6] & 0xFF) << 8 | b[7] & 0xFF : (b[7] & 0xFF) << 24 | (b[6] & 0xFF) << 16 | (b[5] & 0xFF) << 8 | b[4] & 0xFF;
        if (len > 0 && len < 116) {
            int nexttag;
            int n3 = nexttag = bigEndian ? (b[len + 8] & 0xFF) << 24 | (b[len + 9] & 0xFF) << 16 | (b[len + 10] & 0xFF) << 8 | b[len + 11] & 0xFF : (b[len + 9] & 0xFF) << 24 | (b[len + 8] & 0xFF) << 16 | (b[len + 11] & 0xFF) << 8 | b[len + 10] & 0xFF;
            if ((nexttag & 0xFFFF0000) == (tag & 0xFFFF0000) && (nexttag & 0xFFFF) > (tag & 0xFFFF)) {
                return fmi ? (bigEndian ? FileFormat.IVR_BE_FILE_WO_PREAMBLE : FileFormat.IVR_LE_FILE_WO_PREAMBLE) : (bigEndian ? FileFormat.IVR_BE_STREAM : FileFormat.ACRNEMA_STREAM);
            }
        }
        throw new DcmParseException("Unknown Format");
    }

    public int parseHeader() throws IOException {
        this.eof = false;
        try {
            this.b12[0] = this.in.readByte();
        }
        catch (EOFException ex) {
            this.eof = true;
            log.debug("Detect EOF");
            return -1;
        }
        this.in.readFully(this.b12, 1, 7);
        this.rPos += 8L;
        this.rTag = this.bb12.getShort(0) << 16 | this.bb12.getShort(2) & 0xFFFF;
        int retval = 8;
        switch (this.rTag) {
            case -73728: 
            case -73715: 
            case -73507: {
                this.rVR = 0;
                this.rLen = this.bb12.getInt(4);
                break;
            }
            default: {
                if (!this.decodeParam.explicitVR) {
                    this.rVR = this.vrMap.lookup(this.rTag);
                    this.rLen = this.bb12.getInt(4);
                    break;
                }
                this.rVR = this.bb12.get(4) << 8 | this.bb12.get(5) & 0xFF;
                if (VRs.isLengthField16Bit(this.rVR)) {
                    this.rLen = this.bb12.getShort(6) & 0xFFFF;
                    if (this.rVR != 16191) break;
                    if (log.isDebugEnabled()) {
                        log.debug("Replace invalid VR '??' of " + Tags.toString(this.rTag) + " by 'UN'");
                    }
                    this.rVR = 21838;
                    break;
                }
                this.in.readFully(this.b12, 8, 4);
                this.rPos += 4L;
                this.rLen = this.bb12.getInt(8);
                retval = 12;
            }
        }
        if (this.unBuf != null) {
            this.unBuf.write(this.b12, 0, retval);
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logMsg());
        }
        return retval;
    }

    private byte[] parsePreamble() throws IOException {
        log.debug("rPos:" + this.rPos);
        byte[] b128 = new byte[128];
        this.in.readFully(b128, 0, 128);
        this.rPos += 128L;
        this.in.readFully(this.b12, 0, 4);
        this.rPos += 4L;
        if (this.b12[0] != 68 || this.b12[1] != 73 || this.b12[2] != 67 || this.b12[3] != 77) {
            throw new DcmParseException("Missing DICM Prefix");
        }
        return b128;
    }

    public long parseFileMetaInfo(boolean preamble, DcmDecodeParam param) throws IOException {
        byte[] data;
        this.rPos = 0L;
        byte[] byArray = data = preamble ? this.parsePreamble() : null;
        if (this.handler != null) {
            this.handler.startFileMetaInfo(data);
        }
        this.setDcmDecodeParam(param);
        this.parseGroup(2);
        if (this.handler != null) {
            this.handler.endFileMetaInfo();
        }
        return this.rPos;
    }

    public long parseFileMetaInfo() throws IOException {
        return this.parseFileMetaInfo(true, DcmDecodeParam.EVR_LE);
    }

    public long parseCommand() throws IOException {
        if (this.handler != null) {
            this.handler.startCommand();
        }
        this.setDcmDecodeParam(DcmDecodeParam.IVR_LE);
        long read = this.parseGroup(0);
        if (this.handler != null) {
            this.handler.endCommand();
        }
        return read;
    }

    private long parseGroup(int groupTag) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("parse group " + groupTag);
        }
        if (this.handler != null) {
            this.handler.setDcmDecodeParam(this.decodeParam);
        }
        long rPos0 = this.rPos;
        int hlen = this.parseHeader();
        if (hlen != 8 || this.rTag >>> 16 != groupTag || this.rVR != 21836 || this.rLen != 4) {
            throw new DcmParseException("hlen=" + hlen + ", " + this.logMsg());
        }
        this.in.readFully(this.b12, 0, 4);
        this.rPos += 4L;
        if (this.handler != null) {
            this.handler.startElement(this.rTag, this.rVR, rPos0);
            byte[] b4 = new byte[4];
            System.arraycopy(this.b12, 0, b4, 0, 4);
            this.handler.value(b4, 0, 4);
            this.handler.endElement();
        }
        return this.doParse(-1, this.bb12.getInt(0)) + 12L;
    }

    public long parseDataset(String tuid, int stopTag) throws IOException {
        return this.parseDataset(DcmDecodeParam.valueOf(tuid), stopTag);
    }

    public long parseDataset(DcmDecodeParam param, int stopTag) throws IOException {
        if (param != null) {
            this.setDcmDecodeParam(param);
        }
        if (this.handler != null) {
            this.handler.startDataset();
            this.handler.setDcmDecodeParam(this.decodeParam);
        }
        long read = this.doParse(stopTag, -1);
        if (this.handler != null) {
            this.handler.endDataset();
        }
        return read;
    }

    public long parseDcmFile(FileFormat format, int stopTag) throws IOException {
        if (format == null) {
            format = this.detectFileFormat();
        }
        if (this.handler != null) {
            this.handler.startDcmFile();
        }
        DcmDecodeParam param = format.decodeParam;
        this.rPos = 0L;
        if (format.mglib) {
            this.skipMglibHeader();
        } else if (format.hasFileMetaInfo) {
            this.tsUID = null;
            this.parseFileMetaInfo(format.hasPreamble, format.decodeParam);
            if (this.tsUID == null) {
                log.warn("Missing Transfer Syntax UID in FMI");
            } else {
                param = DcmDecodeParam.valueOf(this.tsUID);
            }
        }
        this.parseDataset(param, stopTag);
        if (this.handler != null) {
            this.handler.endDcmFile();
        }
        return this.rPos;
    }

    private void skipMglibHeader() throws IOException {
        String s;
        while ((s = this.in.readLine()) != null) {
            this.rPos += (long)(s.length() + 1);
            if (!"ENDINFO".equals(s)) continue;
            break;
        }
    }

    public long parseItemDataset() throws IOException {
        long lread;
        this.in.readFully(this.b12, 0, 8);
        this.rPos += 8L;
        int itemtag = this.bb12.getShort(0) << 16 | this.bb12.getShort(2) & 0xFFFF;
        int itemlen = this.bb12.getInt(4);
        if (itemtag == -73507) {
            if (itemlen != 0) {
                throw new DcmParseException("(fffe,e0dd), Length:" + itemlen);
            }
            return -1L;
        }
        if (itemtag != -73728) {
            throw new DcmParseException(Tags.toString(itemtag));
        }
        if (log.isDebugEnabled()) {
            log.debug("rpos:" + (this.rPos - 8L) + ",(fffe,e0dd)");
        }
        if (this.handler != null) {
            this.handler.startDataset();
        }
        if (itemlen == -1) {
            lread = this.doParse(-73715, itemlen);
            if (this.rTag != -73715 || this.rLen != 0) {
                throw new DcmParseException(this.logMsg());
            }
        } else {
            lread = this.doParse(-1, itemlen);
        }
        if (this.handler != null) {
            this.handler.endDataset();
        }
        return 8L + lread;
    }

    public void unreadHeader() {
        if (!this.readHeader || this.hLen == -1) {
            throw new IllegalArgumentException();
        }
        this.readHeader = false;
    }

    private long doParse(int stopTag, int length) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("rpos:" + this.rPos + ",stopTag:" + Tags.toString(stopTag) + ",length:" + length);
        }
        long lread = 0L;
        if (length != 0) {
            long llen = (long)length & 0xFFFFFFFFL;
            do {
                long rPos0 = this.rPos;
                if (this.readHeader) {
                    this.hLen = this.parseHeader();
                    if (this.hLen == -1) {
                        if (length == -1) break;
                        throw new EOFException();
                    }
                } else {
                    rPos0 -= (long)this.hLen;
                    this.readHeader = true;
                }
                lread += (long)this.hLen;
                if (((long)stopTag & 0xFFFFFFFFL) <= ((long)this.rTag & 0xFFFFFFFFL)) break;
                if (this.handler != null && this.unBuf == null && this.rTag != -73715) {
                    this.handler.startElement(this.rTag, this.rVR, rPos0);
                }
                if (this.rLen == -1 || this.rVR == 21329) {
                    switch (this.rVR) {
                        case 20290: 
                        case 20294: 
                        case 20311: 
                        case 21329: 
                        case 21838: {
                            break;
                        }
                        default: {
                            throw new DcmParseException(this.logMsg());
                        }
                    }
                    lread += this.parseSequence(this.rVR, this.rLen);
                } else {
                    if (this.rLen < 0) {
                        throw new DcmParseException(this.logMsg() + ", value length [" + ((long)this.rLen & 0xFFFFFFFFL) + "] exceeds maximal supported length[2^31-1]");
                    }
                    this.readValue();
                    lread += (long)this.rLen;
                }
                if (this.handler == null || this.unBuf != null) continue;
                this.handler.endElement();
            } while (length == -1 || lread < llen);
            if (length != -1 && lread > llen) {
                log.info(this.logMsg() + ", value length extend specified read length " + llen + " for " + (lread - llen) + " Bytes!");
            }
        }
        return lread;
    }

    private long parseSequence(int vr, int sqLen) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("rPos:" + this.rPos + "," + VRs.toString(vr) + " #" + sqLen);
        }
        if (this.handler != null && this.unBuf == null) {
            this.handler.startSequence(sqLen);
        }
        long lread = 0L;
        if (sqLen != 0) {
            int itemlen;
            long llen = (long)sqLen & 0xFFFFFFFFL;
            int id = 0;
            block4: do {
                this.in.readFully(this.b12, 0, 8);
                this.rPos += 8L;
                if (this.unBuf != null) {
                    this.unBuf.write(this.b12, 0, 8);
                }
                lread += 8L;
                int itemtag = this.bb12.getShort(0) << 16 | this.bb12.getShort(2) & 0xFFFF;
                itemlen = this.bb12.getInt(4);
                switch (itemtag) {
                    case -73507: {
                        if (sqLen != -1) {
                            log.warn("Unexpected Sequence Delimination Item (fffe,e0dd) for Sequence with explicit length: " + sqLen);
                        }
                        if (itemlen == 0) break block4;
                        throw new DcmParseException("(fffe,e0dd), Length:" + itemlen);
                    }
                    case -73728: {
                        break;
                    }
                    default: {
                        throw new DcmParseException(Tags.toString(itemtag));
                    }
                }
            } while (sqLen == -1 || (lread += this.parseItem(++id, vr, itemlen)) < llen);
            if (sqLen != -1 && lread > llen) {
                throw new DcmParseException(this.logMsg() + ", Read: " + lread + ", Length: " + llen);
            }
        }
        if (this.handler != null && this.unBuf == null) {
            this.handler.endSequence(sqLen);
        }
        return lread;
    }

    private long parseItem(int id, int vr, int itemlen) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("rPos:" + this.rPos + "," + VRs.toString(vr) + " #" + itemlen);
        }
        switch (vr) {
            case 21329: {
                return this.parseSQItem(id, itemlen);
            }
            case 21838: {
                if (itemlen == -1) {
                    return this.parseUNItem(id, itemlen);
                }
            }
            case 20290: 
            case 20294: 
            case 20311: {
                return this.readFragment(id, itemlen);
            }
        }
        throw new RuntimeException(this.logMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long parseUNItem(int id, int itemlen) throws IOException {
        long retval;
        if (this.unBuf != null) {
            retval = this.parseSQItem(id, itemlen);
        } else {
            long rPos0 = this.rPos;
            this.unBuf = new ByteArrayOutputStream();
            DcmDecodeParam tmpDecodeParam = this.decodeParam;
            try {
                this.setDcmDecodeParam(DcmDecodeParam.IVR_LE);
                this.bb12.order(ByteOrder.LITTLE_ENDIAN);
                retval = this.parseSQItem(id, itemlen);
                if (this.handler != null) {
                    this.handler.fragment(id, rPos0 - 8L, this.unBuf.toByteArray(), 0, this.unBuf.size() - 8);
                }
            }
            finally {
                this.setDcmDecodeParam(tmpDecodeParam);
                this.unBuf = null;
            }
        }
        return retval;
    }

    private long parseSQItem(int id, int itemlen) throws IOException {
        long lread;
        if (this.handler != null && this.unBuf == null) {
            this.handler.startItem(id, this.rPos - 8L, itemlen);
        }
        if (itemlen == -1) {
            lread = this.doParse(-73715, itemlen);
            if (this.rTag != -73715 || this.rLen != 0) {
                throw new DcmParseException(this.logMsg());
            }
        } else {
            lread = this.doParse(-1, itemlen);
        }
        if (this.handler != null && this.unBuf == null) {
            this.handler.endItem(itemlen);
        }
        return lread;
    }

    private int readValue() throws IOException {
        byte[] data = this.readBytes(this.rLen);
        if (this.handler != null && this.unBuf == null) {
            this.handler.value(data, 0, this.rLen);
        }
        if (this.rTag == 131088) {
            this.tsUID = this.decodeUID(data, this.rLen - 1);
        }
        return this.rLen;
    }

    private String decodeUID(byte[] data, int rlen1) {
        if (rlen1 < 0) {
            log.warn("Empty Transfer Syntax UID in FMI");
            return "";
        }
        try {
            return new String(data, 0, data[rlen1] == 0 ? rlen1 : rlen1 + 1, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            log.warn("Decoding Transfer Syntax UID in FMI failed!", ex);
            return null;
        }
    }

    private int readFragment(int id, int itemlen) throws IOException {
        long rPos0 = this.rPos;
        byte[] data = this.readBytes(itemlen);
        if (this.handler != null && this.unBuf == null) {
            this.handler.fragment(id, rPos0 - 8L, data, 0, itemlen);
        }
        return itemlen;
    }

    private byte[] readBytes(int len) throws IOException {
        byte[] retval;
        if (len == 0) {
            return this.b0;
        }
        try {
            retval = new byte[len];
        }
        catch (OutOfMemoryError e) {
            throw new DcmParseException(this.logMsg() + ", out of memory allocating byte[]");
        }
        this.in.readFully(retval, 0, len);
        this.rPos += (long)len;
        if (this.unBuf != null) {
            this.unBuf.write(retval, 0, len);
        }
        return retval;
    }
}

