unit MSGSnatchers;

// $Id: MSGSnatchers.pas,v 1.6 2002/04/10 17:06:23 takao Exp $

{$ObjExportAll On}

interface

uses
  Classes, Controls, Messages, Windows;

type
  { TLinkedComponent }
  TLinkedComponent = class(TComponent)
  private
    FPrev: TLinkedComponent;
    FNext: TLinkedComponent;
  protected
    { Template Methods }
    procedure Inserted(aPrev, aNext: TLinkedComponent); virtual;
    procedure Removing(aPrev, aNext: TLinkedComponent); virtual;
  public
    constructor Create(anOwner: TComponent); override;
    destructor Destroy; override;
    procedure InsertBefore(aComponent: TLinkedComponent);
    procedure InsertAfter(aComponent: TLinkedComponent);
    procedure RemoveFromLink;
    property Prev: TLinkedComponent read FPrev;
    property Next: TLinkedComponent read FNext;
  end;

  { Event Types for TMessageSnatcher }
  TMessageHandleEvent = procedure(
    aSender: TObject; var aMessage: TMessage; var aHandled: Boolean) of Object;

  { TCustomMessageSnatcher }
  TCustomMessageSnatcher = class(TLinkedComponent)
  private
    FControl: TControl;
    FOldWndProc: TWndMethod;

    FOnMessage: TMessageHandleEvent;

  protected
    { TComponent }
    procedure Notification(aComponent: TComponent; anOperation: TOperation);
      override;
    procedure Loaded; override;

    { TLinkedComponent }
    procedure Inserted(aPrev, aNext: TLinkedComponent); override;
    procedure Removing(aPrev, aNext: TLinkedComponent); override;

    { Template Methods }
    procedure InitializeControl(aControl: TControl); virtual;
    procedure FinalizeControl(aControl: TControl); virtual;

    procedure SetControl(aControl: TControl);
    procedure MessageHandler(var aMessage: TMessage; var aHandled: Boolean);
      virtual;
    procedure WndProc(var aMessage: TMessage); virtual;

    property OldWndProc: TWndMethod read FOldWndProc;
    property Control: TControl read FControl write SetControl;

    property OnMessage: TMessageHandleEvent read FOnMessage write FOnMessage;
  public
    destructor Destroy; override;
  end;

  { TCustomWinMessageSnatcher }
  TCustomWinMessageSnatcher = class(TCustomMessageSnatcher)
  private
    hwndInitialized_: Boolean;
  protected
    function GetWinControl: TWinControl;
    procedure SetWinControl(aWinControl: TWinControl);
    procedure DoInitializeHWND;
    procedure DoFinalizeHWND;
    { TCustomMessageSnatcher }
    procedure InitializeControl(aControl: TControl); override;
    procedure FinalizeControl(aControl: TControl); override;
    procedure WndProc(var aMessage: TMessage); override;
    { Template Methods }
    procedure InitializeHWND(aHandle: HWND); virtual;
    procedure FinalizeHWND(aHandle: HWND); virtual;

    property WinControl: TWinControl read GetWinControl write SetWinControl;
  end;

  { TMessageSnatcher }
  TMessageSnatcher = class(TCustomMessageSnatcher)
  published
    property Control;
    property OnMessage;
  end;

  { Event types for TWinMessageSnatcher }
  THWNDEvent = procedure(aSender: TObject; aHandle: HWND) of object;

  { TWinMessageSnatcher }
  TWinMessageSnatcher = class(TCustomWinMessageSnatcher)
  private
    FOnInitializeHWND: THWNDEvent;
    FOnFinalizeHWND: THWNDEvent;
  protected
    { TCustomWinMessageSnatcher }
    procedure InitializeHWND(aHandle: HWND); override;
    procedure FinalizeHWND(aHandle: HWND); override;
  published
    property WinControl;
    property OnInitializeHWND: THWNDEvent
      read FOnInitializeHWND write FOnInitializeHWND;
    property OnFinalizeHWND: THWNDEvent
      read FOnFinalizeHWND write FOnFinalizeHWND;
  end;


implementation

uses
  Contnrs;

{ TLinkedComponent }

constructor TLinkedComponent.Create(anOwner: TComponent);
begin
  inherited Create(anOwner);
end;

destructor TLinkedComponent.Destroy;
begin
  RemoveFromLink;
  inherited;
end;

procedure TLinkedComponent.InsertAfter(aComponent: TLinkedComponent);
begin
  RemoveFromLink;
  FPrev := aComponent;
  FNext := aComponent.FNext;
  if FNext <> Nil then FNext.FPrev := Self;
  aComponent.FNext := Self;
  Inserted(FPrev, FNext);
end;

procedure TLinkedComponent.InsertBefore(aComponent: TLinkedComponent);
begin
  RemoveFromLink;
  FPrev := aComponent.FPrev;
  FNext := aComponent;
  if FPrev <> Nil then FPrev.FNext := Self;
  aComponent.FPrev := Self;
  Inserted(FPrev, FNext);
end;

procedure TLinkedComponent.Inserted(aPrev, aNext: TLinkedComponent);
begin
end;

procedure TLinkedComponent.RemoveFromLink;
begin
  Removing(FPrev, FNext);
  if FPrev <> Nil then FPrev.FNext := FNext;
  if FNext <> Nil then FNext.FPrev := FPrev;
  FPrev := Nil;
  FNext := Nil;
end;

procedure TLinkedComponent.Removing(aPrev, aNext: TLinkedComponent);
begin
end;


{ TCustomMessageSnatcher }

{ DONE -oNAKAGUCHI Takao : `F[쐬A
Cӂ̃R|[lg폜Ăɓ삷悤ɂB }
{ DONE -oNAKAGUCHI Takao : vO}[eXg𓱓B }
{ DONE -oNAKAGUCHI Takao : TWinControl pMessageSnatcher쐬B
InitHWND, UninitHWND ev[g\bhBhwndValid_ tOB }

var
  hookChainTails__: TBucketList;  // Rg[ŌɃtbNR|[lg


destructor TCustomMessageSnatcher.Destroy;
begin
  Control := Nil;
  inherited;
end;

procedure TCustomMessageSnatcher.FinalizeControl(aControl: TControl);
begin
end;

procedure TCustomMessageSnatcher.InitializeControl(aControl: TControl);
begin
end;

procedure TCustomMessageSnatcher.Loaded;
var
  c: TControl;
begin
  inherited;

  if csDesigning in ComponentState then Exit;

  if FControl <> Nil then begin
    c := FControl;
    FControl := Nil;
    Control := c;
  end;
end;

procedure TCustomMessageSnatcher.MessageHandler(var aMessage: TMessage;
  var aHandled: Boolean);
begin
end;

procedure TCustomMessageSnatcher.Notification(aComponent: TComponent;
  anOperation: TOperation);
begin
  inherited;

  if (aComponent = FControl) and (anOperation = opRemove) then
    Control := Nil;
end;

procedure TCustomMessageSnatcher.Inserted(aPrev, aNext: TLinkedComponent);
var
  prev, next: TCustomMessageSnatcher;
begin
  if aPrev <> Nil then prev := aPrev as TCustomMessageSnatcher
  else prev := Nil;
  if aNext <> Nil then next := aNext as TCustomMessageSnatcher
  else next := Nil;

  if prev <> Nil then begin
    FControl := prev.FControl;
  end else if next <> Nil then begin
    FControl := next.FControl;
  end;
  InitializeControl(FControl);
  FControl.FreeNotification(Self);

  if prev <> Nil then begin
    FOldWndProc := prev.WndProc;
  end else begin
    FOldWndProc := FControl.WindowProc;
  end;

  if next <> Nil then begin
    next.FOldWndProc := WndProc;
  end else begin
    FControl.WindowProc := WndProc;
    hookChainTails__.Remove(FControl);
    hookChainTails__.Add(FControl, Self);
  end;
end;

procedure TCustomMessageSnatcher.Removing(aPrev, aNext: TLinkedComponent);
  function MethodEquals(aMethod1, aMethod2: TMethod): Boolean;
  begin
    Result :=
      (aMethod1.Code = aMethod2.Code)
      and
      (aMethod1.Data = aMethod2.Data)
  end;
var
  method: TWndMethod;
  prev, next, tail: TCustomMessageSnatcher;
begin
  if FControl = Nil then Exit;
  if aPrev <> Nil then prev := aPrev as TCustomMessageSnatcher
  else prev := Nil;
  if aNext <> Nil then next := aNext as TCustomMessageSnatcher
  else next := Nil;

  // restore WindowProc
  method := WndProc;
  if MethodEquals(TMethod(FControl.WindowProc), TMethod(method)) then begin
    if prev <> Nil then
      FControl.WindowProc := prev.WndProc
    else
      FControl.WindowProc := FOldWndProc;
  end;

  // set OldWndProc of Next
  if next <> Nil then
    next.FOldWndProc := FOldWndProc;

  // set chain tail to Prev if tail is Self
  if hookChainTails__.Find(FControl, Pointer(tail)) then
    if tail = Self then begin
      hookChainTails__.Remove(FControl);
      if aPrev <> Nil then
        hookChainTails__.Add(FControl, aPrev);
    end;

  FOldWndProc := Nil;
  FinalizeControl(FControl);
  FControl := Nil;
end;

procedure TCustomMessageSnatcher.SetControl(aControl: TControl);
var
  tail: TCustomMessageSnatcher;
begin
  if (csLoading in ComponentState) or (csDesigning in ComponentState) then begin
    FControl := aControl;
    Exit;
  end;

  if FControl <> Nil then begin
    RemoveFromLink;
  end;

  if aControl <> Nil then begin
    // add self to hook chain
    if hookChainTails__.Find(aControl, Pointer(tail)) then begin
      InsertAfter(tail);
    end else begin
      FControl := aControl;
      Inserted(Nil, Nil);
    end;
  end;
end;

procedure TCustomMessageSnatcher.WndProc(var aMessage: TMessage);
var
  handled: Boolean;
begin
  handled := False;

  MessageHandler(aMessage, handled);

  if (not handled) and Assigned(FOnMessage) then
    FOnMessage(Self, aMessage, handled);

  if (not handled) and Assigned(FOldWndProc) then
    FOldWndProc(aMessage);
end;


{ TCustomWinMessageSnatcher }

procedure TCustomWinMessageSnatcher.DoFinalizeHWND;
begin
  if hwndInitialized_ then begin
    FinalizeHWnd(WinControl.Handle);
    hwndInitialized_ := False;
  end;
end;

procedure TCustomWinMessageSnatcher.DoInitializeHWND;
begin
  if not hwndInitialized_ then begin
    InitializeHWnd(WinControl.Handle);
    hwndInitialized_ := True;
  end;
end;

procedure TCustomWinMessageSnatcher.FinalizeControl(aControl: TControl);
begin
  DoFinalizeHWND;
end;

procedure TCustomWinMessageSnatcher.FinalizeHWND(aHandle: HWND);
begin
end;

function TCustomWinMessageSnatcher.GetWinControl: TWinControl;
begin
  Result := Control as TWinControl;
end;

procedure TCustomWinMessageSnatcher.InitializeControl(aControl: TControl);
begin
  DoInitializeHWND;
end;

procedure TCustomWinMessageSnatcher.InitializeHWND(aHandle: HWND);
begin
end;

procedure TCustomWinMessageSnatcher.SetWinControl(aWinControl: TWinControl);
begin
  Control := aWinControl;
end;

procedure TCustomWinMessageSnatcher.WndProc(var aMessage: TMessage);
begin
  case aMessage.Msg of
    WM_CREATE:  DoInitializeHWND;
    WM_DESTROY: DoFinalizeHWND;
  end;
  inherited;
end;


{ TWinMessageSnatcher }

procedure TWinMessageSnatcher.FinalizeHWND(aHandle: HWND);
begin
  inherited;
  if Assigned(FOnFinalizeHWND) then FOnFinalizeHWND(Self, aHandle);
end;

procedure TWinMessageSnatcher.InitializeHWND(aHandle: HWND);
begin
  inherited;
  if Assigned(FOnInitializeHWND) then FOnInitializeHWND(Self, aHandle);
end;


initialization
  hookChainTails__ := TBucketList.Create;

finalization
  hookChainTails__.Free;

end.
