<#--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->
<script src="/catalog/imagemanagement/js/jquery.min.js"></script>
<script type="text/javascript">
jQuery.noConflict();
jQuery(document).ready(function(){
    jQuery('input:radio').click(function(){
        var elementVal = jQuery(this).val();
        var elementList = elementVal.split('__');
        var result = elementList[0] + "/" + elementList[1];
        jQuery('input:radio[value=' + result + ']').attr('checked',true);
    });
    jQuery('input:radio[value^="IM_APPROVED"]').each( function() {
        this.checked = true;
    });
});
</script>
        
<table>
    <#if partyRoles?has_content>
        <#assign alt_row = false>
        <#list partyRoles as partyRole>
            <td>
                <table>
                    <#assign userLoginApprovers  = delegator.findByAnd("UserLogin",Static["org.ofbiz.base.util.UtilMisc"].toMap("partyId", partyRole.partyId))/>
                    <#assign userLoginApprover = userLoginApprovers[0]>
                    <#assign userLoginAndPartyDetails = delegator.findByPrimaryKey("UserLoginAndPartyDetails", Static["org.ofbiz.base.util.UtilMisc"].toMap("partyId", userLoginApprover.partyId, "userLoginId", userLoginApprover.userLoginId))?if_exists>
                    <#if userLoginAndPartyDetails?has_content>
                        <#assign partyContentDetail  = delegator.findByAnd("ContentApproval",Static["org.ofbiz.base.util.UtilMisc"].toMap("roleTypeId", "IMAGEAPPROVER", "approvalStatusId", "IM_PENDING", "partyId", userLoginAndPartyDetails.partyId))/>
                        <#assign imageApproveSize = partyContentDetail.size()>
                        <#if userLoginAndPartyDetails.userLoginId == userLogin.userLoginId>
                            <#if userMap.checkUser == userLoginAndPartyDetails.userLoginId>
                                <td>
                                    <div>
                                        <b>${userLoginAndPartyDetails.firstName?if_exists} ${userLoginAndPartyDetails.middleName?if_exists} ${userLoginAndPartyDetails.lastName?if_exists} (${imageApproveSize})</b>&nbsp;&nbsp;|&nbsp;&nbsp;
                                    </div>
                                </td>
                            <#else>
                                <td>
                                    <div>
                                        <b><a href="<@ofbizUrl>ImageApprove</@ofbizUrl>" class="text">${userLoginAndPartyDetails.firstName?if_exists} ${userLoginAndPartyDetails.middleName?if_exists} ${userLoginAndPartyDetails.lastName?if_exists} (${imageApproveSize})</a></b>&nbsp;&nbsp;|&nbsp;&nbsp;
                                    </div>
                                </td>
                            </#if>
                        <#else>
                            <#if userMap.checkUser == userLoginAndPartyDetails.userLoginId>
                                <td>
                                    <div>
                                        <b>${userLoginAndPartyDetails.firstName?if_exists} ${userLoginAndPartyDetails.middleName?if_exists} ${userLoginAndPartyDetails.lastName?if_exists} (${imageApproveSize})</b>&nbsp;&nbsp;|&nbsp;&nbsp;
                                    </div>
                                </td>
                            <#else>
                                <td>
                                    <div>
                                        <b><a href="<@ofbizUrl>ListPeopleApproved?createdByUserLogin=${userLoginAndPartyDetails.userLoginId}</@ofbizUrl>" class="text">${userLoginAndPartyDetails.firstName?if_exists} ${userLoginAndPartyDetails.middleName?if_exists} ${userLoginAndPartyDetails.lastName?if_exists} (${imageApproveSize})</a></b>&nbsp;&nbsp;|&nbsp;&nbsp;
                                    </div>
                                </td>
                            </#if>
                        </#if>
                    </#if>
                </table>
            </td>
        </#list>
        <#if userMap.checkUser == "REJECTED">
            <td>
                <div><b>${uiLabelMap.CommonRejected}</b></div>
            </td>
        <#else>
            <td>
                <div><b><a href="<@ofbizUrl>ListPeopleRejected</@ofbizUrl>" class="text">${uiLabelMap.CommonRejected}</a></b></div>
            </td>
        </#if>
    </#if>
</table>
<br/>
