/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.CacheStrategy;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FilesCache;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs.events.AbstractFileChangeEvent;
import org.apache.commons.vfs.events.ChangedEvent;
import org.apache.commons.vfs.events.CreateEvent;
import org.apache.commons.vfs.events.DeleteEvent;
import org.apache.commons.vfs.provider.AbstractVfsComponent;
import org.apache.commons.vfs.provider.FileSystemKey;
import org.apache.commons.vfs.util.Messages;

public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$vfs$provider$AbstractFileSystem == null ? (class$org$apache$commons$vfs$provider$AbstractFileSystem = AbstractFileSystem.class$("org.apache.commons.vfs.provider.AbstractFileSystem")) : class$org$apache$commons$vfs$provider$AbstractFileSystem));
    private final FileName rootName;
    private FileObject parentLayer;
    private final Collection caps = new HashSet();
    private final Map listenerMap = new HashMap();
    private final FileSystemOptions fileSystemOptions;
    private long useCount;
    private FileSystemKey cacheKey;
    private int openStreams;
    static /* synthetic */ Class class$org$apache$commons$vfs$provider$AbstractFileSystem;

    protected AbstractFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        this.parentLayer = parentLayer;
        this.rootName = rootName;
        this.fileSystemOptions = fileSystemOptions;
    }

    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    public void close() {
        this.closeCommunicationLink();
        this.parentLayer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCommunicationLink() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            this.doCloseCommunicationLink();
        }
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(FileName var1) throws Exception;

    protected abstract void addCapabilities(Collection var1);

    public FileName getRootName() {
        return this.rootName;
    }

    protected void putFileToCache(FileObject file) {
        this.getCache().putFile(file);
    }

    private FilesCache getCache() {
        FilesCache files = this.getContext().getFileSystemManager().getFilesCache();
        if (files == null) {
            throw new RuntimeException(Messages.getString("vfs.provider/files-cache-missing.error"));
        }
        return files;
    }

    protected FileObject getFileFromCache(FileName name) {
        return this.getCache().getFile(this, name);
    }

    protected void removeFileFromCache(FileName name) {
        this.getCache().removeFile(this, name);
    }

    public boolean hasCapability(Capability capability) {
        return this.caps.contains(capability);
    }

    public Object getAttribute(String attrName) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    public void setAttribute(String attrName, Object value) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    public FileObject resolveFile(String nameStr) throws FileSystemException {
        FileName name = this.getFileSystemManager().resolveName(this.rootName, nameStr);
        return this.resolveFile(name);
    }

    public synchronized FileObject resolveFile(FileName name) throws FileSystemException {
        return this.resolveFile(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileObject resolveFile(FileName name, boolean useCache) throws FileSystemException {
        if (!this.rootName.getRootURI().equals(name.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", new Object[]{name, this.rootName, name.getRootURI()});
        }
        FileObject file = useCache ? this.getFileFromCache(name) : null;
        if (file == null) {
            try {
                AbstractFileSystem abstractFileSystem = this;
                synchronized (abstractFileSystem) {
                    file = this.createFile(name);
                }
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/resolve-file.error", name, (Throwable)e);
            }
            file = this.decorateFileObject(file);
            if (useCache) {
                this.putFileToCache(file);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals(CacheStrategy.ON_RESOLVE)) {
            file.refresh();
        }
        return file;
    }

    protected FileObject decorateFileObject(FileObject file) throws FileSystemException {
        if (this.getFileSystemManager().getCacheStrategy().equals(CacheStrategy.ON_CALL)) {
            file = new OnCallRefreshFileObject(file);
        }
        if (this.getFileSystemManager().getFileObjectDecoratorConst() != null) {
            try {
                file = (FileObject)this.getFileSystemManager().getFileObjectDecoratorConst().newInstance(file);
            }
            catch (InstantiationException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)e);
            }
        }
        return file;
    }

    public File replicateFile(FileObject file, FileSelector selector) throws FileSystemException {
        if (!file.exists()) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", file.getName());
        }
        try {
            return this.doReplicateFile(file, selector);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/replicate-file.error", file.getName(), (Throwable)e);
        }
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject file, FileSelector selector) throws Exception {
        return this.getContext().getReplicator().replicateFile(file, selector);
    }

    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    public void removeJunction(String junctionPoint) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileObject file, FileListener listener) {
        Map map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> listeners = (ArrayList<FileListener>)this.listenerMap.get(file.getName());
            if (listeners == null) {
                listeners = new ArrayList<FileListener>();
                this.listenerMap.put(file.getName(), listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FileObject file, FileListener listener) {
        Map map = this.listenerMap;
        synchronized (map) {
            ArrayList listeners = (ArrayList)this.listenerMap.get(file.getName());
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    public void fireFileCreated(FileObject file) {
        this.fireEvent(new CreateEvent(file));
    }

    public void fireFileDeleted(FileObject file) {
        this.fireEvent(new DeleteEvent(file));
    }

    public void fireFileChanged(FileObject file) {
        this.fireEvent(new ChangedEvent(file));
    }

    public boolean isReleaseable() {
        return this.useCount < 1L;
    }

    void freeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent event) {
        FileListener[] fileListeners = null;
        FileObject file = event.getFile();
        Map map = this.listenerMap;
        synchronized (map) {
            ArrayList listeners = (ArrayList)this.listenerMap.get(file.getName());
            if (listeners != null) {
                fileListeners = listeners.toArray(new FileListener[listeners.size()]);
            }
        }
        if (fileListeners != null) {
            for (int i = 0; i < fileListeners.length; ++i) {
                FileListener fileListener = fileListeners[i];
                try {
                    event.notify(fileListener);
                    continue;
                }
                catch (Exception e) {
                    String message = Messages.getString("vfs.provider/notify-listener.warn", file);
                    VfsLog.warn(this.getLogger(), log, message, e);
                }
            }
        }
    }

    void fileObjectHanded(FileObject fileObject) {
        ++this.useCount;
    }

    void fileObjectDestroyed(FileObject fileObject) {
        --this.useCount;
    }

    void setCacheKey(FileSystemKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    FileSystemKey getCacheKey() {
        return this.cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            ++this.openStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.notifyAllStreamsClosed();
                }
            }
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            return this.openStreams > 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

