/*
 * Decompiled with CFR 0.152.
 */
package watermarker.model;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import org.apache.commons.lang.builder.EqualsBuilder;
import watermarker.model.WatermarkSettings;

public class WatermarkerSettings {
    public static final WatermarkerSettings DEFAULT = new WatermarkerSettings();
    private AlphaComposite alphaComposite;
    private Color graphicsColor;
    private Font graphicsFont;
    private WatermarkSettings watermarkSettings;
    private String formatName;

    public AlphaComposite getAlphaComposite() {
        return this.alphaComposite;
    }

    public void setAlphaComposite(AlphaComposite alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    public Color getGraphicsColor() {
        return this.graphicsColor;
    }

    public void setGraphicsColor(Color graphicsColor) {
        this.graphicsColor = graphicsColor;
    }

    public Font getGraphicsFont() {
        return this.graphicsFont;
    }

    public void setGraphicsFont(Font graphicsFont) {
        this.graphicsFont = graphicsFont;
    }

    public WatermarkSettings getWatermarkSettings() {
        return this.watermarkSettings;
    }

    public void setWatermarkSettings(WatermarkSettings watermarkSettings) {
        this.watermarkSettings = watermarkSettings;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public Object clone() throws CloneNotSupportedException {
        WatermarkerSettings clone = new WatermarkerSettings();
        AlphaComposite alphaComposite = this.alphaComposite != null ? AlphaComposite.getInstance(this.alphaComposite.getRule(), this.alphaComposite.getAlpha()) : null;
        clone.setAlphaComposite(alphaComposite);
        clone.setFormatName(this.formatName);
        Color graphicsColor = this.graphicsColor != null ? new Color(this.graphicsColor.getRGB()) : null;
        clone.setGraphicsColor(graphicsColor);
        Font graphicsFont = this.graphicsFont != null ? new Font(this.graphicsFont.getAttributes()) : null;
        clone.setGraphicsFont(graphicsFont);
        WatermarkSettings watermarkSettings = this.watermarkSettings != null ? (WatermarkSettings)this.watermarkSettings.clone() : null;
        clone.setWatermarkSettings(watermarkSettings);
        return clone;
    }

    public boolean equals(Object object) {
        if (!(object instanceof WatermarkerSettings)) {
            return false;
        }
        WatermarkerSettings rhs = (WatermarkerSettings)object;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.graphicsFont, (Object)rhs.graphicsFont);
        equalsBuilder.append((Object)this.formatName, (Object)rhs.formatName);
        equalsBuilder.append((Object)this.graphicsColor, (Object)rhs.graphicsColor);
        equalsBuilder.append((Object)this.watermarkSettings, (Object)rhs.watermarkSettings);
        equalsBuilder.append((Object)this.alphaComposite, (Object)rhs.alphaComposite);
        return equalsBuilder.isEquals();
    }

    static {
        AlphaComposite defaultAlphaComposite = AlphaComposite.getInstance(3, 0.5f);
        DEFAULT.setAlphaComposite(defaultAlphaComposite);
        String defaultFormatName = "jpg";
        DEFAULT.setFormatName(defaultFormatName);
        Color defaultGraphicsColor = new Color(125, 125, 125);
        DEFAULT.setGraphicsColor(defaultGraphicsColor);
        Font defaultGraphicsFont = new Font("Courier", 1, 30);
        DEFAULT.setGraphicsFont(defaultGraphicsFont);
        DEFAULT.setWatermarkSettings(WatermarkSettings.DEFAULT);
    }
}

