/*
 * Decompiled with CFR 0.152.
 */
package watermarker.impl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.util.Properties;
import watermarker.WatermarkerSettingsManager;
import watermarker.model.WatermarkSettings;
import watermarker.model.WatermarkerSettings;

public class DefaultWatermarkerSettingsManager
implements WatermarkerSettingsManager {
    public WatermarkerSettings load(Properties properties) {
        WatermarkerSettings watermarkerSettings = new WatermarkerSettings();
        AlphaComposite alphaComposite = this.getAlphaComposite(properties);
        watermarkerSettings.setAlphaComposite(alphaComposite);
        Color graphicsColor = this.getGraphicsColor(properties);
        watermarkerSettings.setGraphicsColor(graphicsColor);
        Font graphicsFont = this.getGraphicsFont(properties);
        watermarkerSettings.setGraphicsFont(graphicsFont);
        WatermarkSettings watermarkSettings = this.getWatermarkSettings(properties);
        watermarkerSettings.setWatermarkSettings(watermarkSettings);
        String formatName = this.getProperty(properties, "watermark.output.formatname");
        watermarkerSettings.setFormatName(formatName);
        return watermarkerSettings;
    }

    private WatermarkSettings getWatermarkSettings(Properties properties) {
        WatermarkSettings watermarkSettings = new WatermarkSettings();
        String marker = this.getProperty(properties, "watermarker.watermark.position.marker");
        float x = this.getFloatProperty(properties, "watermarker.watermark.position.x");
        float y = this.getFloatProperty(properties, "watermarker.watermark.position.y");
        watermarkSettings.setMarker(marker);
        watermarkSettings.setX(x);
        watermarkSettings.setY(y);
        return watermarkSettings;
    }

    private Font getGraphicsFont(Properties properties) {
        String fontFamily = this.getProperty(properties, "watermark.text.font.family");
        int fontStyle = this.getIntProperty(properties, "watermark.text.font.style");
        int fontSize = this.getIntProperty(properties, "watermark.text.font.size");
        Font graphicsFont = new Font(fontFamily, fontStyle, fontSize);
        return graphicsFont;
    }

    private Color getGraphicsColor(Properties properties) {
        int rColorAttribute = this.getIntProperty(properties, "watermark.text.redvalue");
        int gColorAttribute = this.getIntProperty(properties, "watermark.text.greenvalue");
        int bColorAttribute = this.getIntProperty(properties, "watermark.text.bluevalue");
        Color graphicsColor = new Color(rColorAttribute, gColorAttribute, bColorAttribute);
        return graphicsColor;
    }

    private AlphaComposite getAlphaComposite(Properties properties) {
        int rule = this.getIntProperty(properties, "watermark.alpha.rule");
        float value = this.getFloatProperty(properties, "watermark.alpha.value");
        AlphaComposite alphaComposite = AlphaComposite.getInstance(rule, value);
        return alphaComposite;
    }

    private String getProperty(Properties properties, String key) {
        return properties.getProperty(key);
    }

    private float getFloatProperty(Properties properties, String key) {
        return Float.parseFloat(properties.getProperty(key));
    }

    private int getIntProperty(Properties properties, String key) {
        return Integer.parseInt(properties.getProperty(key));
    }
}

