/*
 * Decompiled with CFR 0.152.
 */
package watermarker.impl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import watermarker.Watermarker;
import watermarker.WatermarkerSettingsManager;
import watermarker.exception.WatermarkerException;
import watermarker.impl.DefaultWatermarkerSettingsManager;
import watermarker.model.WatermarkSettings;
import watermarker.model.WatermarkerSettings;

public class DefaultWatermarker
implements Watermarker {
    public static final String INPUT_EXCEPTION_MESSAGE = "A problem occured while reading the destination image";
    public static final String OUTPUT_EXCEPTION_MESSAGE = "A problem occured while writing the watermarked image.";
    private WatermarkerSettingsManager watermarkerSettingsManager;
    private ImageObserver imageObserver;
    private static final ImageObserver DEFAULT_IMAGE_OBSERVER = null;
    private static final WatermarkerSettingsManager DEFAULT_WATERMARKER_SETTINGS_MANAGER = new DefaultWatermarkerSettingsManager();

    public void watermark(URL imageUrl, String watermarkText, OutputStream output, Properties properties) throws WatermarkerException {
        WatermarkerSettings watermarkerSettings = this.getWatermarkerSettingsManagerWithDefault().load(properties);
        this.watermark(imageUrl, watermarkText, output, watermarkerSettings);
    }

    public void watermark(URL imageUrl, URL watermarkUrl, OutputStream output, Properties properties) throws WatermarkerException {
        WatermarkerSettings watermarkerSettings = this.getWatermarkerSettingsManagerWithDefault().load(properties);
        this.watermark(imageUrl, watermarkUrl, output, watermarkerSettings);
    }

    private BufferedImage retrieveImage(URL imageUrl) throws WatermarkerException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new WatermarkerException(INPUT_EXCEPTION_MESSAGE);
        }
        return bufferedImage;
    }

    public void watermark(URL imageUrl, String watermarkText, OutputStream output, WatermarkerSettings watermarkerSettings) throws WatermarkerException {
        BufferedImage destinationImage = this.retrieveImage(imageUrl);
        Graphics2D graphics = (Graphics2D)destinationImage.getGraphics();
        AlphaComposite alphaComposite = watermarkerSettings.getAlphaComposite();
        graphics.setComposite(alphaComposite);
        graphics.drawImage((Image)destinationImage, 0, 0, this.getImageObserverWithDefault());
        Color graphicsColor = watermarkerSettings.getGraphicsColor();
        graphics.setColor(graphicsColor);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font graphicsFont = watermarkerSettings.getGraphicsFont();
        graphics.setFont(graphicsFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D watermarkBounds = fontMetrics.getStringBounds(watermarkText, graphics);
        WatermarkSettings watermarkSettings = watermarkerSettings.getWatermarkSettings();
        Point sourcePosition = this.getPosition(destinationImage, watermarkBounds, watermarkSettings);
        int x = (int)sourcePosition.getX();
        int y = (int)sourcePosition.getY();
        graphics.drawString(watermarkText, x, y);
        graphics.dispose();
        try {
            String watermarkOutputImageFormat = watermarkerSettings.getFormatName();
            ImageIO.write((RenderedImage)destinationImage, watermarkOutputImageFormat, output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new WatermarkerException(OUTPUT_EXCEPTION_MESSAGE, e);
        }
    }

    public void watermark(URL imageUrl, URL watermarkUrl, OutputStream output, WatermarkerSettings watermarkerSettings) throws WatermarkerException {
        BufferedImage destinationImage = this.retrieveImage(imageUrl);
        BufferedImage sourceImage = this.retrieveImage(watermarkUrl);
        Graphics2D graphics = (Graphics2D)destinationImage.getGraphics();
        AlphaComposite alphaComposite = watermarkerSettings.getAlphaComposite();
        graphics.setComposite(alphaComposite);
        graphics.drawImage((Image)destinationImage, 0, 0, this.getImageObserverWithDefault());
        Color graphicsColor = watermarkerSettings.getGraphicsColor();
        graphics.setColor(graphicsColor);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font graphicsFont = watermarkerSettings.getGraphicsFont();
        graphics.setFont(graphicsFont);
        WatermarkSettings watermarkSettings = watermarkerSettings.getWatermarkSettings();
        Point sourcePosition = this.getPosition(destinationImage, sourceImage, watermarkSettings);
        int x = (int)sourcePosition.getX();
        int y = (int)sourcePosition.getY();
        graphics.drawImage((Image)sourceImage, x, y, this.getImageObserverWithDefault());
        graphics.dispose();
        try {
            String watermarkOutputImageFormat = watermarkerSettings.getFormatName();
            ImageIO.write((RenderedImage)destinationImage, watermarkOutputImageFormat, output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new WatermarkerException(OUTPUT_EXCEPTION_MESSAGE, e);
        }
    }

    public Point getPosition(BufferedImage destinationImage, BufferedImage sourceImage, WatermarkSettings watermarkSettings) {
        String marker = watermarkSettings.getMarker();
        float xRelative = watermarkSettings.getX();
        float yRelative = watermarkSettings.getY();
        int destinationWidth = destinationImage.getWidth();
        int destinationHeight = destinationImage.getHeight();
        int sourceHeight = sourceImage.getHeight();
        int sourceWidth = sourceImage.getWidth();
        int x = (int)(xRelative * (float)destinationWidth);
        int y = (int)(yRelative * (float)destinationHeight);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(x, y, sourceWidth, sourceHeight);
        Point location = rectangle.getLocation();
        int leftX = 0;
        int rightX = sourceWidth;
        int topY = 0;
        int bottomY = -sourceHeight;
        int centerX = (leftX - rightX) / 2;
        int centerY = (bottomY - topY) / 2;
        this.moveLocation(location, marker, leftX, rightX, topY, bottomY, centerY, centerX);
        return location;
    }

    public Point getPosition(BufferedImage destinationImage, Rectangle2D textBounds, WatermarkSettings watermarkSettings) {
        String marker = watermarkSettings.getMarker();
        float xRelative = watermarkSettings.getX();
        float yRelative = watermarkSettings.getY();
        int destinationWidth = destinationImage.getWidth();
        int destinationHeight = destinationImage.getHeight();
        int sourceHeight = (int)textBounds.getHeight();
        int sourceWidth = (int)textBounds.getWidth();
        int x = (int)(xRelative * (float)destinationWidth);
        int y = (int)(yRelative * (float)destinationHeight);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(x, y, sourceWidth, sourceHeight);
        Point location = rectangle.getLocation();
        int leftX = 0;
        int rightX = sourceWidth;
        int topY = sourceHeight;
        int bottomY = 0;
        int centerY = -(bottomY - topY) / 2;
        int centerX = (leftX - rightX) / 2;
        this.moveLocation(location, marker, leftX, rightX, topY, bottomY, centerY, centerX);
        return location;
    }

    private void moveLocation(Point location, String marker, int leftX, int rightX, int topY, int bottomY, int centerY, int centerX) {
        if ("center".equalsIgnoreCase(marker)) {
            location.translate(centerX, centerY);
        } else if ("topLeft".equalsIgnoreCase(marker)) {
            location.translate(leftX, topY);
        } else if ("topRight".equalsIgnoreCase(marker)) {
            location.translate(-rightX, topY);
        } else if ("bottomLeft".equalsIgnoreCase(marker)) {
            location.translate(leftX, bottomY);
        } else if ("bottomRight".equalsIgnoreCase(marker)) {
            location.translate(-rightX, bottomY);
        }
    }

    public WatermarkerSettingsManager getWatermarkerSettingsManager() {
        return this.watermarkerSettingsManager;
    }

    public void setWatermarkerSettingsManager(WatermarkerSettingsManager watermarkerSettingsManager) {
        this.watermarkerSettingsManager = watermarkerSettingsManager;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.imageObserver = imageObserver;
    }

    public WatermarkerSettingsManager getWatermarkerSettingsManagerWithDefault() {
        WatermarkerSettingsManager watermarkerSettingsManager = this.watermarkerSettingsManager != null ? this.watermarkerSettingsManager : DEFAULT_WATERMARKER_SETTINGS_MANAGER;
        return watermarkerSettingsManager;
    }

    public ImageObserver getImageObserverWithDefault() {
        ImageObserver imageObserver = this.imageObserver != null ? this.imageObserver : DEFAULT_IMAGE_OBSERVER;
        return imageObserver;
    }
}

