/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ResourceTypeAwareContextLoader;
import org.springframework.test.context.support.AbstractGenericContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfigContextLoader
extends AbstractGenericContextLoader {
    private static final Log logger = LogFactory.getLog(AnnotationConfigContextLoader.class);

    @Override
    protected void loadBeanDefinitions(GenericApplicationContext context, String ... classNames) {
        Object[] configClasses = new Class[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            String className = classNames[i];
            try {
                configClasses[i] = context.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("The supplied class name [%s] does not represent a class.", className), e);
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering configuration classes: " + ObjectUtils.nullSafeToString((Object[])configClasses)));
        }
        new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)context).register((Class[])configClasses);
    }

    @Override
    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        return null;
    }

    @Override
    protected String[] generateDefaultLocations(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        String suffix = this.getResourceSuffix();
        Assert.hasText((String)suffix, (String)"Resource suffix must not be empty");
        return new String[]{String.valueOf(clazz.getName()) + suffix};
    }

    @Override
    protected String[] modifyLocations(Class<?> clazz, String ... classNames) {
        return classNames;
    }

    @Override
    protected String getResourceSuffix() {
        return "$ContextConfiguration";
    }

    @Override
    public final ResourceTypeAwareContextLoader.ResourceType getResourceType() {
        return ResourceTypeAwareContextLoader.ResourceType.CLASSES;
    }
}

