/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.ContextLoaderUtils;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContext
extends AttributeAccessorSupport {
    private static final long serialVersionUID = -5827157174866681233L;
    private static final Log logger = LogFactory.getLog(TestContext.class);
    private final ContextCache contextCache;
    private final String contextKey;
    private final MergedContextConfiguration mergedContextConfiguration;
    private final Class<?> testClass;
    private Object testInstance;
    private Method testMethod;
    private Throwable testException;

    TestContext(Class<?> testClass, ContextCache contextCache) {
        this(testClass, contextCache, null);
    }

    TestContext(Class<?> testClass, ContextCache contextCache, String defaultContextLoaderClassName) {
        MergedContextConfiguration mergedContextConfiguration;
        Assert.notNull(testClass, (String)"Test class must not be null");
        Assert.notNull((Object)contextCache, (String)"ContextCache must not be null");
        ContextConfiguration contextConfiguration = testClass.getAnnotation(ContextConfiguration.class);
        if (contextConfiguration == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("@ContextConfiguration not found for class [%s]", testClass));
            }
            mergedContextConfiguration = new MergedContextConfiguration(testClass, null, null, null, null);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ContextConfiguration [%s] for class [%s]", contextConfiguration, testClass));
            }
            mergedContextConfiguration = ContextLoaderUtils.buildMergedContextConfiguration(testClass, defaultContextLoaderClassName);
        }
        this.contextCache = contextCache;
        this.contextKey = this.generateContextKey(mergedContextConfiguration);
        this.mergedContextConfiguration = mergedContextConfiguration;
        this.testClass = testClass;
    }

    private ApplicationContext loadApplicationContext() throws Exception {
        ApplicationContext applicationContext;
        ContextLoader contextLoader = this.mergedContextConfiguration.getContextLoader();
        Assert.notNull((Object)contextLoader, (String)"Can not load an ApplicationContext with a NULL 'contextLoader'. Consider annotating your test class with @ContextConfiguration.");
        if (contextLoader instanceof SmartContextLoader) {
            SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
            applicationContext = smartContextLoader.loadContext(this.mergedContextConfiguration);
        } else {
            String[] locations = this.mergedContextConfiguration.getLocations();
            Assert.notNull((Object)locations, (String)"Can not load an ApplicationContext with a NULL 'locations' array. Consider annotating your test class with @ContextConfiguration.");
            applicationContext = contextLoader.loadContext(locations);
        }
        return applicationContext;
    }

    private String generateContextKey(MergedContextConfiguration mergedContextConfiguration) {
        Object[] locations = mergedContextConfiguration.getLocations();
        Object[] classes = mergedContextConfiguration.getClasses();
        Object[] activeProfiles = mergedContextConfiguration.getActiveProfiles();
        ContextLoader contextLoader = mergedContextConfiguration.getContextLoader();
        String locationsKey = ObjectUtils.nullSafeToString((Object[])locations);
        String classesKey = ObjectUtils.nullSafeToString((Object[])classes);
        String activeProfilesKey = ObjectUtils.nullSafeToString((Object[])activeProfiles);
        String contextLoaderKey = contextLoader == null ? "null" : contextLoader.getClass().getName();
        return String.format("locations = [%s], classes = [%s], activeProfiles = [%s], contextLoader = [%s]", locationsKey, classesKey, activeProfilesKey, contextLoaderKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext getApplicationContext() {
        ContextCache contextCache = this.contextCache;
        synchronized (contextCache) {
            ApplicationContext context = this.contextCache.get(this.contextKey);
            if (context == null) {
                try {
                    context = this.loadApplicationContext();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Storing ApplicationContext for test class [%s] in cache under key [%s].", this.testClass, this.contextKey));
                    }
                    this.contextCache.put(this.contextKey, context);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to load ApplicationContext", ex);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Retrieved ApplicationContext for test class [%s] from cache with key [%s].", this.testClass, this.contextKey));
            }
            return context;
        }
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Object getTestInstance() {
        return this.testInstance;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    public final Throwable getTestException() {
        return this.testException;
    }

    public void markApplicationContextDirty() {
        this.contextCache.setDirty(this.contextKey);
    }

    void updateState(Object testInstance, Method testMethod, Throwable testException) {
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.testException = testException;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("testInstance", this.testInstance).append("testMethod", (Object)this.testMethod).append("testException", (Object)this.testException).append("mergedContextConfiguration", (Object)this.mergedContextConfiguration).toString();
    }
}

