/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.Arrays;
import java.util.TreeSet;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedContextConfiguration {
    private final Class<?> testClass;
    private final String[] locations;
    private final Class<?>[] classes;
    private final String[] activeProfiles;
    private final ContextLoader contextLoader;

    private static String[] processLocations(String[] locations) {
        return locations == null ? new String[]{} : locations;
    }

    private static Class<?>[] processClasses(Class<?>[] classes) {
        return classes == null ? new Class[]{} : classes;
    }

    private static String[] processActiveProfiles(String[] activeProfiles) {
        if (activeProfiles == null) {
            return new String[0];
        }
        TreeSet sortedProfilesSet = new TreeSet(Arrays.asList(activeProfiles));
        return StringUtils.toStringArray(sortedProfilesSet);
    }

    public MergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, String[] activeProfiles, ContextLoader contextLoader) {
        this.testClass = testClass;
        this.locations = MergedContextConfiguration.processLocations(locations);
        this.classes = MergedContextConfiguration.processClasses(classes);
        this.activeProfiles = MergedContextConfiguration.processActiveProfiles(activeProfiles);
        this.contextLoader = contextLoader;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public String[] getActiveProfiles() {
        return this.activeProfiles;
    }

    public ContextLoader getContextLoader() {
        return this.contextLoader;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.locations)).append("classes", (Object)ObjectUtils.nullSafeToString((Object[])this.classes)).append("activeProfiles", (Object)ObjectUtils.nullSafeToString((Object[])this.activeProfiles)).append("contextLoader", (Object)this.contextLoader).toString();
    }
}

