/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.ResourceTypeAwareContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ContextLoaderUtils {
    private static final Log logger = LogFactory.getLog(ContextLoaderUtils.class);
    private static final String STANDARD_DEFAULT_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.support.GenericXmlContextLoader";
    private static final ResourcePathLocationsResolver resourcePathLocationsResolver = new ResourcePathLocationsResolver();
    private static final ClassNameLocationsResolver classNameLocationsResolver = new ClassNameLocationsResolver();

    ContextLoaderUtils() {
    }

    static ContextLoader resolveContextLoader(Class<?> testClass, String defaultContextLoaderClassName) {
        Assert.notNull(testClass, (String)"Test class must not be null");
        if (!StringUtils.hasText((String)defaultContextLoaderClassName)) {
            defaultContextLoaderClassName = STANDARD_DEFAULT_CONTEXT_LOADER_CLASS_NAME;
        }
        Class<? extends ContextLoader> contextLoaderClass = ContextLoaderUtils.resolveContextLoaderClass(testClass, defaultContextLoaderClassName);
        return (ContextLoader)BeanUtils.instantiateClass(contextLoaderClass);
    }

    static Class<? extends ContextLoader> resolveContextLoaderClass(Class<?> clazz, String defaultContextLoaderClassName) {
        ContextConfiguration contextConfiguration;
        Assert.notNull(clazz, (String)"Class must not be null");
        Assert.hasText((String)defaultContextLoaderClassName, (String)"Default ContextLoader class name must not be null or empty");
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        Assert.notNull((Object)declaringClass, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType, clazz));
        while (declaringClass != null) {
            Class<? extends ContextLoader> contextLoaderClass;
            contextConfiguration = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Processing ContextLoader for @ContextConfiguration [" + contextConfiguration + "] and declaring class [" + declaringClass + "]"));
            }
            if (!ContextLoader.class.equals(contextLoaderClass = contextConfiguration.loader())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found explicit ContextLoader [" + contextLoaderClass + "] for @ContextConfiguration [" + contextConfiguration + "] and declaring class [" + declaringClass + "]"));
                }
                return contextLoaderClass;
            }
            declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass());
        }
        try {
            if (logger.isTraceEnabled()) {
                contextConfiguration = clazz.getAnnotation(annotationType);
                logger.trace((Object)("Using default ContextLoader class [" + defaultContextLoaderClassName + "] for @ContextConfiguration [" + contextConfiguration + "] and class [" + clazz + "]"));
            }
            return ContextLoaderUtils.class.getClassLoader().loadClass(defaultContextLoaderClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Could not load default ContextLoader class [" + defaultContextLoaderClassName + "]. Specify @ContextConfiguration's 'loader' " + "attribute or make the default loader class available.");
        }
    }

    static String[] resolveContextLocations(ContextLoader contextLoader, Class<?> clazz) {
        Assert.notNull((Object)contextLoader, (String)"ContextLoader must not be null");
        Assert.notNull(clazz, (String)"Class must not be null");
        boolean processConfigurationClasses = contextLoader instanceof ResourceTypeAwareContextLoader && ResourceTypeAwareContextLoader.ResourceType.CLASSES == ((ResourceTypeAwareContextLoader)contextLoader).getResourceType();
        LocationsResolver locationsResolver = processConfigurationClasses ? classNameLocationsResolver : resourcePathLocationsResolver;
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        Assert.notNull((Object)declaringClass, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType, clazz));
        ArrayList locationsList = new ArrayList();
        while (declaringClass != null) {
            ContextConfiguration contextConfiguration = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ContextConfiguration [%s] for declaring class [%s].", contextConfiguration, declaringClass));
            }
            String[] resolvedLocations = locationsResolver.resolveLocations(contextConfiguration, declaringClass);
            String[] processedLocations = contextLoader.processLocations(declaringClass, resolvedLocations);
            locationsList.addAll(0, Arrays.asList(processedLocations));
            Class clazz2 = declaringClass = contextConfiguration.inheritLocations() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
        }
        return StringUtils.toStringArray(locationsList);
    }

    static String[] resolveActiveProfiles(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        if (declaringClass == null && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType, clazz));
        }
        HashSet<String> activeProfiles = new HashSet<String>();
        while (declaringClass != null) {
            ActiveProfiles annotation = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s].", annotation, declaringClass));
            }
            Object[] profiles = annotation.profiles();
            Object[] valueProfiles = annotation.value();
            if (!ObjectUtils.isEmpty((Object[])valueProfiles) && !ObjectUtils.isEmpty((Object[])profiles)) {
                String msg = String.format("Test class [%s] has been configured with @ActiveProfiles' 'value' [%s] and 'profiles' [%s] attributes. Only one declaration of active bean definition profiles is permitted per @ActiveProfiles annotation.", declaringClass, ObjectUtils.nullSafeToString((Object[])valueProfiles), ObjectUtils.nullSafeToString((Object[])profiles));
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            if (!ObjectUtils.isEmpty((Object[])valueProfiles)) {
                profiles = valueProfiles;
            }
            Object[] objectArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Object profile = objectArray[n2];
                if (StringUtils.hasText((String)profile)) {
                    activeProfiles.add(((String)profile).trim());
                }
                ++n2;
            }
            Class clazz2 = declaringClass = annotation.inheritProfiles() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
        }
        return StringUtils.toStringArray(activeProfiles);
    }

    static List<ContextConfigurationAttributes> resolveContextConfigurationAttributes(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        ArrayList<ContextConfigurationAttributes> attributesList = new ArrayList<ContextConfigurationAttributes>();
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        Assert.notNull((Object)declaringClass, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType, clazz));
        while (declaringClass != null) {
            ContextConfiguration contextConfiguration = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ContextConfiguration [%s] for declaring class [%s].", contextConfiguration, declaringClass));
            }
            ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(declaringClass, contextConfiguration);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Resolved context configuration attributes: " + attributes));
            }
            attributesList.add(0, attributes);
            Class clazz2 = declaringClass = contextConfiguration.inheritLocations() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
        }
        return attributesList;
    }

    static MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, String defaultContextLoaderClassName) {
        ContextLoader contextLoader = ContextLoaderUtils.resolveContextLoader(testClass, defaultContextLoaderClassName);
        String[] locations = ContextLoaderUtils.resolveContextLocations(contextLoader, testClass);
        Class[] classes = new Class[]{};
        String[] activeProfiles = ContextLoaderUtils.resolveActiveProfiles(testClass);
        return new MergedContextConfiguration(testClass, locations, classes, activeProfiles, contextLoader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassNameLocationsResolver
    implements LocationsResolver {
        private ClassNameLocationsResolver() {
        }

        @Override
        public String[] resolveLocations(ContextConfiguration contextConfiguration, Class<?> declaringClass) {
            String[] classNames = null;
            Object[] configClasses = contextConfiguration.classes();
            if (!ObjectUtils.isEmpty((Object[])configClasses)) {
                classNames = new String[configClasses.length];
                int i = 0;
                while (i < configClasses.length) {
                    classNames[i] = ((Class)configClasses[i]).getName();
                    ++i;
                }
            }
            return classNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LocationsResolver {
        public String[] resolveLocations(ContextConfiguration var1, Class<?> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResourcePathLocationsResolver
    implements LocationsResolver {
        private ResourcePathLocationsResolver() {
        }

        @Override
        public String[] resolveLocations(ContextConfiguration contextConfiguration, Class<?> declaringClass) {
            return ContextConfigurationAttributes.resolveLocations(declaringClass, contextConfiguration);
        }
    }
}

