/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextConfigurationAttributes {
    private static final Log logger = LogFactory.getLog(ContextConfigurationAttributes.class);
    private final Class<?> declaringClass;
    private final String[] locations;
    private final Class<?>[] classes;
    private final boolean inheritLocations;
    private final Class<? extends ContextLoader> contextLoader;

    static String[] resolveLocations(Class<?> declaringClass, ContextConfiguration contextConfiguration) {
        Object[] locations = contextConfiguration.locations();
        Object[] valueLocations = contextConfiguration.value();
        if (!ObjectUtils.isEmpty((Object[])valueLocations) && !ObjectUtils.isEmpty((Object[])locations)) {
            String msg = String.format("Test class [%s] has been configured with @ContextConfiguration's 'value' [%s] and 'locations' [%s] attributes. Only one declaration of resource locations is permitted per @ContextConfiguration annotation.", declaringClass, ObjectUtils.nullSafeToString((Object[])valueLocations), ObjectUtils.nullSafeToString((Object[])locations));
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        if (!ObjectUtils.isEmpty((Object[])valueLocations)) {
            locations = valueLocations;
        }
        return locations;
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, ContextConfiguration contextConfiguration) {
        this(declaringClass, ContextConfigurationAttributes.resolveLocations(declaringClass, contextConfiguration), contextConfiguration.classes(), contextConfiguration.inheritLocations(), contextConfiguration.loader());
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ContextLoader> contextLoader) {
        this.declaringClass = declaringClass;
        this.locations = locations;
        this.classes = classes;
        this.inheritLocations = inheritLocations;
        this.contextLoader = contextLoader;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public boolean isInheritLocations() {
        return this.inheritLocations;
    }

    public Class<? extends ContextLoader> getContextLoader() {
        return this.contextLoader;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("declaringClass", this.declaringClass).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.locations)).append("classes", (Object)ObjectUtils.nullSafeToString((Object[])this.classes)).append("inheritLocations", this.inheritLocations).append("contextLoader", this.contextLoader).toString();
    }
}

