/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UploadFileSpec {
    private File _file;
    private InputStream _inputStream;
    private String _fileName;
    private String _contentType = "text/plain";
    private static String[][] CONTENT_EXTENSIONS = new String[][]{{"text/plain", "txt", "text"}, {"text/html", "htm", "html"}, {"image/gif", "gif"}, {"image/jpeg", "jpg", "jpeg"}, {"image/png", "png"}, {"image/tiff", "tif", "tiff"}, {"application/pdf", "pdf"}, {"application/octet-stream", "zip"}};

    public UploadFileSpec(File file) {
        this._file = file;
        this.guessContentType();
    }

    public UploadFileSpec(File file, String contentType) {
        this._file = file;
        this._contentType = contentType;
    }

    public UploadFileSpec(String fileName, InputStream inputStream, String contentType) {
        this._fileName = fileName;
        this._inputStream = inputStream;
        this._contentType = contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = new FileInputStream(this._file);
        }
        return this._inputStream;
    }

    public String getFileName() {
        if (this._fileName == null) {
            this._fileName = this._file.getAbsolutePath();
        }
        return this._fileName;
    }

    public String getContentType() {
        return this._contentType;
    }

    private void guessContentType() {
        String extension = this.getExtension(this._file.getName());
        for (int i = 0; i < CONTENT_EXTENSIONS.length; ++i) {
            for (int j = 1; j < CONTENT_EXTENSIONS[i].length; ++j) {
                if (!extension.equalsIgnoreCase(CONTENT_EXTENSIONS[i][j])) continue;
                this._contentType = CONTENT_EXTENSIONS[i][0];
                return;
            }
        }
    }

    private String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1);
    }
}

