/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.javascript;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.javascript.JavaScript;
import com.meterware.httpunit.javascript.ScriptingEngineImpl;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingEngineFactory;
import com.meterware.httpunit.scripting.ScriptingHandler;

public class JavaScriptEngineFactory
implements ScriptingEngineFactory {
    public boolean isEnabled() {
        try {
            Class.forName("org.mozilla.javascript.Context");
            return true;
        }
        catch (Exception e) {
            System.err.println("Rhino classes (js.jar) not found - Javascript disabled");
            return false;
        }
    }

    public void associate(WebResponse response) {
        try {
            JavaScript.run(response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            HttpUnitUtils.handleException(e);
            throw new RuntimeException(e.toString());
        }
    }

    public void load(WebResponse response) {
        try {
            JavaScript.load(response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public void setThrowExceptionsOnError(boolean throwExceptions) {
        JavaScript.setThrowExceptionsOnError(throwExceptions);
    }

    public boolean isThrowExceptionsOnError() {
        return JavaScript.isThrowExceptionsOnError();
    }

    public String[] getErrorMessages() {
        return ScriptingEngineImpl.getErrorMessages();
    }

    public void clearErrorMessages() {
        ScriptingEngineImpl.clearErrorMessages();
    }

    public ScriptingHandler createHandler(HTMLElement elementBase) {
        ScriptableDelegate delegate = elementBase.newScriptable();
        delegate.setScriptEngine(elementBase.getParentDelegate().getScriptEngine(delegate));
        return delegate;
    }

    public ScriptingHandler createHandler(WebResponse response) {
        return response.createJavascriptScriptingHandler();
    }
}

