/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.dom;

import com.meterware.httpunit.dom.AttrImpl;
import com.meterware.httpunit.dom.CDATASectionImpl;
import com.meterware.httpunit.dom.CommentImpl;
import com.meterware.httpunit.dom.ElementImpl;
import com.meterware.httpunit.dom.NodeImpl;
import com.meterware.httpunit.dom.ProcessingInstructionImpl;
import com.meterware.httpunit.dom.TextImpl;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLElement;

public class DocumentImpl
extends NodeImpl
implements Document {
    private Element _documentElement;

    static DocumentImpl createDocument() {
        DocumentImpl document = new DocumentImpl();
        document.initialize();
        return document;
    }

    protected void initialize() {
    }

    public String getNodeName() {
        return "#document";
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
    }

    public short getNodeType() {
        return 9;
    }

    public Document getOwnerDocument() {
        return this;
    }

    public DocumentType getDoctype() {
        return null;
    }

    public DOMImplementation getImplementation() {
        return null;
    }

    public Element getDocumentElement() {
        return this._documentElement;
    }

    void setDocumentElement(Element documentElement) {
        if (this._documentElement != null) {
            throw new IllegalStateException("A document may have only one root");
        }
        this._documentElement = documentElement;
        this.appendChild(documentElement);
    }

    public Element createElement(String tagName) throws DOMException {
        return ElementImpl.createElement(this, tagName);
    }

    public DocumentFragment createDocumentFragment() {
        throw new UnsupportedOperationException("DocumentFragment creation not supported ");
    }

    public Text createTextNode(String data) {
        return TextImpl.createText(this, data);
    }

    public Comment createComment(String data) {
        return CommentImpl.createComment(this, data);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return CDATASectionImpl.createCDATASection(this, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return ProcessingInstructionImpl.createProcessingImpl(this, target, data);
    }

    public Attr createAttribute(String name) throws DOMException {
        return AttrImpl.createAttribute(this, name);
    }

    public EntityReference createEntityReference(String name) throws DOMException {
        throw new UnsupportedOperationException("EntityReference creation not supported ");
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        switch (importedNode.getNodeType()) {
            case 2: {
                return AttrImpl.importNode(this, (Attr)importedNode);
            }
            case 4: {
                return CDATASectionImpl.importNode(this, (CDATASection)importedNode);
            }
            case 8: {
                return CommentImpl.importNode(this, (Comment)importedNode);
            }
            case 1: {
                return ElementImpl.importNode(this, (Element)importedNode, deep);
            }
            case 7: {
                return ProcessingInstructionImpl.importNode(this, (ProcessingInstruction)importedNode);
            }
            case 3: {
                return TextImpl.importNode(this, (Text)importedNode);
            }
        }
        throw new DOMException(9, "Cannot import node type " + importedNode.getNodeType());
    }

    public Element getElementById(String elementId) {
        Iterator each = this.preOrderIterator();
        while (each.hasNext()) {
            HTMLElement element;
            Node node = (Node)each.next();
            if (!(node instanceof HTMLElement) || !elementId.equals((element = (HTMLElement)node).getId())) continue;
            return element;
        }
        return null;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return ElementImpl.createElement(this, namespaceURI, qualifiedName);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return AttrImpl.createAttribute(this, namespaceURI, qualifiedName);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        if (namespaceURI != null) {
            throw new UnsupportedOperationException("Namespaces are not supported");
        }
        return this.getElementsByTagName(localName);
    }

    void importChildren(Node original, Node copy) {
        NodeList children = original.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node childCopy = this.importNode(children.item(i), true);
            copy.appendChild(childCopy);
        }
    }

    public String getInputEncoding() {
        return null;
    }

    public String getXmlEncoding() {
        return null;
    }

    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public boolean getXmlStandalone() {
        return false;
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    public String getXmlVersion() {
        return null;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    public String getDocumentURI() {
        return null;
    }

    public void setDocumentURI(String documentURI) {
    }

    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public void normalizeDocument() {
    }
}

