/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import java.io.IOException;
import org.xml.sax.SAXException;

public class SubmitButton
extends Button {
    private boolean _fake;
    private static boolean allowUnnamedImageButton = false;
    private String[] _value = new String[1];
    private final boolean _isImageButton;
    private boolean _pressed;
    private int _x;
    private int _y;

    public String getType() {
        return this.isImageButton() ? "image" : "submit";
    }

    public boolean isImageButton() {
        return this._isImageButton;
    }

    public void click(int x, int y) throws IOException, SAXException {
        if (!this.isImageButton()) {
            throw new IllegalStateException("May only specify positions for an image button");
        }
        this.doOnClickSequence(x, y);
    }

    protected void doButtonAction(int x, int y) throws IOException, SAXException {
        this.getForm().doFormSubmit(this, x, y);
    }

    public String toString() {
        return "Submit with " + this.getName() + "=" + this.getValue();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getValue().hashCode();
    }

    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass()) && this.equals((SubmitButton)o);
    }

    SubmitButton(WebForm form, HTMLControl control) {
        super(form, control);
        this._isImageButton = control.getType().equalsIgnoreCase("image");
    }

    SubmitButton(WebForm form) {
        super(form);
        this._isImageButton = false;
    }

    static SubmitButton createFakeSubmitButton(WebForm form) {
        return new SubmitButton(form, true);
    }

    private SubmitButton(WebForm form, boolean fake) {
        this(form);
        this._fake = fake;
    }

    public boolean isFake() {
        return this._fake;
    }

    void setPressed(boolean pressed) {
        this._pressed = pressed;
    }

    void setLocation(int x, int y) {
        this._x = x;
        this._y = y;
    }

    protected String[] getValues() {
        return this.isDisabled() || !this._pressed ? NO_VALUE : this.toArray(this.getValue());
    }

    public static boolean isAllowUnnamedImageButton() {
        return allowUnnamedImageButton;
    }

    public static void setAllowUnnamedImageButton(boolean allowUnnamedImageButton) {
        SubmitButton.allowUnnamedImageButton = allowUnnamedImageButton;
    }

    public boolean isValidImageButton() {
        String buttonName = this.getName();
        boolean valid = this.isImageButton();
        if (!allowUnnamedImageButton) {
            valid = valid && buttonName != null && buttonName.length() > 0;
        }
        return valid;
    }

    public String positionParameterName(String direction) {
        String buttonName = this.getName();
        String buttonPrefix = "";
        if (buttonName != null && buttonName.length() > 0) {
            buttonPrefix = buttonName + ".";
        }
        return buttonPrefix + direction;
    }

    protected void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this._pressed && !this.isDisabled()) {
            String buttonName = this.getName();
            if (buttonName != null && buttonName.length() > 0 && this.getValue().length() > 0) {
                processor.addParameter(this.getName(), this.getValue(), characterSet);
            }
            if (this.isValidImageButton()) {
                processor.addParameter(this.positionParameterName("x"), Integer.toString(this._x), characterSet);
                processor.addParameter(this.positionParameterName("y"), Integer.toString(this._y), characterSet);
            }
        }
    }

    private String[] toArray(String value) {
        this._value[0] = value;
        return this._value;
    }

    private boolean equals(SubmitButton button) {
        return this.getName().equals(button.getName()) && (this.getName().length() == 0 || this.getValue().equals(button.getValue()));
    }

    public void throwDisabledException() {
        throw new DisabledSubmitButtonException(this);
    }

    class DisabledSubmitButtonException
    extends Button.DisabledButtonException {
        DisabledSubmitButtonException(SubmitButton button) {
            super(button);
        }

        public String getMessage() {
            return "The specified button (name='" + this._name + "' value='" + this._value + "' is disabled and may not be used to submit this form.";
        }
    }
}

