/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.scripting.DocumentElement;
import com.meterware.httpunit.scripting.ScriptableDelegate;

class HTMLElementScriptable
extends ScriptableDelegate
implements DocumentElement {
    private HTMLElement _element;

    protected HTMLElement get_element() {
        return this._element;
    }

    public Object get(String propertyName) {
        if (propertyName.equals("nodeName")) {
            return this._element.getTagName();
        }
        if (propertyName.equals("tagName")) {
            return this._element.getTagName();
        }
        if (propertyName.equalsIgnoreCase("title")) {
            return this._element.getTitle();
        }
        if (this._element.isSupportedAttribute(propertyName)) {
            return this._element.getAttribute(propertyName);
        }
        return super.get(propertyName);
    }

    public String getAttribute(String attributeName) {
        return this._element.getAttribute(attributeName);
    }

    public void setAttribute(String attributeName, Object value) {
        this._element.setAttribute(attributeName, value);
    }

    public void removeAttribute(String attributeName) {
        this._element.removeAttribute(attributeName);
    }

    public boolean handleEvent(String eventName) {
        if (eventName.toLowerCase().equals("onclick")) {
            this.handleEvent("onmousedown");
        }
        String eventScript = this.getAttribute(eventName);
        boolean result = this.doEventScript(eventScript);
        if (eventName.toLowerCase().equals("onclick")) {
            this.handleEvent("onmouseup");
        }
        return result;
    }

    public HTMLElementScriptable(HTMLElement element) {
        this._element = element;
    }
}

