/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.DNSListener;

public class ClientProperties {
    private String _applicationCodeName = "httpunit";
    private String _applicationName = "HttpUnit";
    private String _applicationVersion = "1.5";
    private String _userAgent;
    private String _platform = "Java";
    private String _overrideContextType = null;
    private int _availWidth = 800;
    private int _availHeight = 600;
    private boolean _iframeSupported = true;
    private boolean _acceptCookies = true;
    private boolean _acceptGzip = true;
    private boolean _autoRedirect = true;
    private boolean _autoRefresh = false;
    private DNSListener _dnsListener;
    private boolean _sendReferer;
    private static ClientProperties _defaultProperties = new ClientProperties();

    public static ClientProperties getDefaultProperties() {
        return _defaultProperties;
    }

    public void setApplicationID(String applicationName, String applicationCodeName, String applicationVersion) {
        this._applicationCodeName = applicationCodeName;
        this._applicationName = applicationName;
        this._applicationVersion = applicationVersion;
    }

    public String getApplicationCodeName() {
        return this._applicationCodeName;
    }

    public void setApplicationCodeName(String applicationCodeName) {
        this._applicationCodeName = applicationCodeName;
    }

    public String getApplicationName() {
        return this._applicationName;
    }

    public void setApplicationName(String applicationName) {
        this._applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this._applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this._applicationVersion = applicationVersion;
    }

    public String getUserAgent() {
        return this._userAgent != null ? this._userAgent : this._applicationCodeName + '/' + this._applicationVersion;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    public String getPlatform() {
        return this._platform;
    }

    public void setPlatform(String platform) {
        this._platform = platform;
    }

    public void setAvailableScreenSize(int width, int height) {
        this._availWidth = width;
        this._availHeight = height;
    }

    public int getAvailableScreenWidth() {
        return this._availWidth;
    }

    public void setAvailableScreenWidth(int availWidth) {
        this._availWidth = availWidth;
    }

    public int getAvailHeight() {
        return this._availHeight;
    }

    public void setAvailHeight(int availHeight) {
        this._availHeight = availHeight;
    }

    public boolean isAcceptCookies() {
        return this._acceptCookies;
    }

    public void setAcceptCookies(boolean acceptCookies) {
        this._acceptCookies = acceptCookies;
    }

    public boolean isAcceptGzip() {
        return this._acceptGzip;
    }

    public void setAcceptGzip(boolean acceptGzip) {
        this._acceptGzip = acceptGzip;
    }

    public boolean isAutoRedirect() {
        return this._autoRedirect;
    }

    public void setAutoRedirect(boolean autoRedirect) {
        this._autoRedirect = autoRedirect;
    }

    public boolean isAutoRefresh() {
        return this._autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this._autoRefresh = autoRefresh;
    }

    public boolean isIframeSupported() {
        return this._iframeSupported;
    }

    public void setIframeSupported(boolean iframeSupported) {
        this._iframeSupported = iframeSupported;
    }

    public String getOverrideContextType() {
        return this._overrideContextType;
    }

    public void setOverrideContextType(String overrideContextType) {
        this._overrideContextType = overrideContextType;
    }

    public void setDnsListener(DNSListener dnsListener) {
        this._dnsListener = dnsListener;
    }

    DNSListener getDnsListener() {
        return this._dnsListener;
    }

    public boolean isSendReferer() {
        return this._sendReferer;
    }

    public void setSendReferer(boolean referer) {
        this._sendReferer = referer;
    }

    ClientProperties cloneProperties() {
        return new ClientProperties(this);
    }

    private ClientProperties() {
        this._sendReferer = true;
    }

    private ClientProperties(ClientProperties source) {
        this._applicationCodeName = source._applicationCodeName;
        this._applicationName = source._applicationName;
        this._applicationVersion = source._applicationVersion;
        this._userAgent = source._userAgent;
        this._platform = source._platform;
        this._overrideContextType = source._overrideContextType;
        this._iframeSupported = source._iframeSupported;
        this._acceptCookies = source._acceptCookies;
        this._acceptGzip = source._acceptGzip;
        this._autoRedirect = source._autoRedirect;
        this._autoRefresh = source._autoRefresh;
        this._sendReferer = source._sendReferer;
    }
}

