/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.dom.HTMLButtonElementImpl;
import com.meterware.httpunit.dom.HTMLControl;
import com.meterware.httpunit.dom.HTMLInputElementImpl;
import com.meterware.httpunit.protocol.ParameterProcessor;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import org.xml.sax.SAXException;

public class Button
extends FormControl {
    public static final HTMLElementPredicate WITH_ID = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object button, Object id) {
            return ((Button)button).getID().equals(id);
        }
    };
    public static final HTMLElementPredicate WITH_LABEL = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object button, Object label) {
            return ((Button)button).getValue().equals(label);
        }
    };
    private WebResponse _baseResponse;
    private boolean _wasEnabled = true;

    public String getType() {
        return "button";
    }

    Button(WebForm form) {
        super(form);
    }

    Button(WebForm form, HTMLControl control) {
        super(form, control);
    }

    Button(WebResponse response, HTMLControl control) {
        super(null, control);
        this._baseResponse = response;
    }

    public String getValue() {
        return this.emptyIfNull(this.getNode() instanceof HTMLInputElementImpl ? ((HTMLInputElementImpl)this.getNode()).getValue() : ((HTMLButtonElementImpl)this.getNode()).getValue());
    }

    protected boolean doOnClickSequence(int x, int y) throws IOException, SAXException {
        this.verifyButtonEnabled();
        boolean result = this.doOnClickEvent();
        if (result) {
            this.doButtonAction(x, y);
        }
        this.rememberEnableState();
        return result;
    }

    public void click() throws IOException, SAXException {
        this.doOnClickSequence(0, 0);
    }

    boolean wasEnabled() {
        return this._wasEnabled;
    }

    public void rememberEnableState() {
        this._wasEnabled = !this.isDisabled();
    }

    protected void verifyButtonEnabled() {
        this.rememberEnableState();
        if (this.isDisabled()) {
            this.throwDisabledException();
        }
    }

    public void throwDisabledException() {
        throw new DisabledButtonException(this);
    }

    public boolean isDisabled() {
        return super.isDisabled();
    }

    protected void doButtonAction(int x, int y) throws IOException, SAXException {
    }

    protected void doButtonAction() throws IOException, SAXException {
        this.doButtonAction(0, 0);
    }

    protected String[] getValues() {
        return new String[0];
    }

    protected void addValues(ParameterProcessor processor, String characterSet) throws IOException {
    }

    public ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    public ScriptableDelegate getParentDelegate() {
        if (this.getForm() != null) {
            return super.getParentDelegate();
        }
        return this._baseResponse.getDocumentScriptable();
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
            super(Button.this);
        }

        public void click() throws IOException, SAXException {
            Button.this.doButtonAction();
        }
    }

    class DisabledButtonException
    extends IllegalStateException {
        protected String _name;
        protected String _value;

        DisabledButtonException(Button button) {
            this._name = button.getName();
            this._value = button.getValue();
        }

        public String getMessage() {
            String msg = "Button" + (Button.this.getName().length() == 0 ? "" : " '" + Button.this.getName() + "'") + " is disabled and may not be clicked.";
            return msg;
        }
    }
}

