/*
 * Decompiled with CFR 0.152.
 */
package jimm.util;

import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import jimm.util.StringUtils;

public class XMLWriter
extends PrintWriter {
    protected static final int DEFAULT_INDENTATION_WIDTH = 4;
    protected int width;
    protected int level;
    protected boolean newline;
    protected ArrayList elementStack;
    protected boolean inElementStart;

    public XMLWriter(OutputStream outputStream) {
        super(outputStream);
        this.init(4);
    }

    public XMLWriter(OutputStream outputStream, boolean bl, int n) {
        super(outputStream, bl);
        this.init(n);
    }

    public XMLWriter(Writer writer) {
        super(writer);
        this.init(4);
    }

    public XMLWriter(Writer writer, boolean bl, int n) {
        super(writer, bl);
        this.init(n);
    }

    protected void init(int n) {
        this.width = n;
        this.level = 0;
        this.newline = true;
        this.elementStack = new ArrayList();
        this.inElementStart = false;
    }

    public void indent() {
        ++this.level;
    }

    public void outdent() {
        if (--this.level < 0) {
            this.level = 0;
        }
    }

    public void print(boolean bl) {
        this.doIndent();
        super.print(bl);
    }

    public void print(char c) {
        this.doIndent();
        super.print(c);
        if (c == '\n') {
            this.newline = true;
        }
    }

    public void print(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.print(cArray[i]);
        }
    }

    public void print(double d) {
        this.doIndent();
        super.print(d);
    }

    public void print(float f) {
        this.doIndent();
        super.print(f);
    }

    public void print(int n) {
        this.doIndent();
        super.print(n);
    }

    public void print(long l) {
        this.doIndent();
        super.print(l);
    }

    public void print(Object object) {
        this.print(object.toString());
    }

    public void print(String string) {
        this.doIndent();
        super.print(string);
    }

    public void println() {
        super.println();
        this.newline = true;
    }

    public void println(boolean bl) {
        this.doIndent();
        super.println(bl);
    }

    public void println(char c) {
        this.doIndent();
        super.println(c);
        if (c == '\n') {
            this.newline = true;
            this.doIndent();
            this.newline = true;
        }
    }

    public void println(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            this.print(cArray[i]);
        }
        this.println();
    }

    public void println(double d) {
        this.doIndent();
        super.println(d);
        this.newline = true;
    }

    public void println(float f) {
        this.doIndent();
        super.println(f);
        this.newline = true;
    }

    public void println(int n) {
        this.doIndent();
        super.println(n);
        this.newline = true;
    }

    public void println(long l) {
        this.doIndent();
        super.println(l);
        this.newline = true;
    }

    public void println(Object object) {
        this.println(object.toString());
    }

    public void println(String string) {
        this.doIndent();
        super.println(string);
        this.newline = true;
    }

    protected void doIndent() {
        if (this.newline) {
            int n;
            for (n = this.level * this.width; n >= 8; n -= 8) {
                super.print("\t");
            }
            super.print("        ".substring(0, n));
            this.newline = false;
        }
    }

    public void xmlDecl(String string) {
        this.println("<?xml version=\"1.0\" encoding=\"" + string + "\"?>");
    }

    protected void finishStartElement(boolean bl) {
        this.inElementStart = false;
        this.print('>');
        if (bl) {
            this.println();
        }
    }

    protected void finishStartElement() {
        this.inElementStart = false;
        this.println('>');
    }

    protected void parentShouldOutdent() {
        ElementInfo elementInfo = (ElementInfo)this.elementStack.get(this.elementStack.size() - 1);
        elementInfo.outdentBeforeEnd = true;
    }

    public void startElement(String string) {
        if (this.inElementStart) {
            this.finishStartElement();
            this.indent();
            this.parentShouldOutdent();
        }
        this.elementStack.add(new ElementInfo(string));
        this.inElementStart = true;
        this.doIndent();
        this.print("<" + string);
    }

    public void attr(String string, String string2) {
        this.print(" " + string + "=\"" + StringUtils.escapeXML(string2) + "\"");
    }

    public void attr(String string, double d) {
        this.print(" " + string + "=\"" + d + "\"");
    }

    public void attr(String string, int n) {
        this.print(" " + string + "=\"" + n + "\"");
    }

    public void attr(String string, char c) {
        this.attr(string, "" + c);
    }

    public void attr(String string, boolean bl) {
        this.attr(string, bl ? "true" : "false");
    }

    public void attr(String string, Color color) {
        this.attr(string, "" + color.getRed() + ';' + color.getGreen() + ';' + color.getBlue() + ';' + color.getAlpha());
    }

    public void attr(String string, Object object) {
        this.attr(string, object.toString());
    }

    public void endElement() {
        ElementInfo elementInfo = (ElementInfo)this.elementStack.remove(this.elementStack.size() - 1);
        if (elementInfo.outdentBeforeEnd) {
            this.outdent();
        }
        if (this.inElementStart) {
            this.inElementStart = false;
            this.println("/>");
        } else {
            this.doIndent();
            this.println("</" + elementInfo.name + ">");
        }
    }

    public void cdataElement(String string, String string2) {
        this.startElement(string);
        this.cdata(string2);
        this.endElement();
    }

    public void cdata(String string) {
        if (this.inElementStart) {
            this.finishStartElement(false);
        }
        this.print("<![CDATA[" + (string == null ? "" : string) + "]]>");
    }

    public void textElement(String string, String string2) {
        this.startElement(string);
        this.text(string2);
        this.endElement();
    }

    public void text(String string) {
        if (this.inElementStart) {
            this.finishStartElement(false);
        }
        this.print(StringUtils.escapeXML(string == null ? "" : string));
    }

    public void comment(String string) {
        if (this.inElementStart) {
            this.finishStartElement();
        }
        this.doIndent();
        this.println("<!-- " + string + " -->");
    }

    static class ElementInfo {
        String name;
        boolean outdentBeforeEnd;

        ElementInfo(String string) {
            this.name = string;
            this.outdentBeforeEnd = false;
        }
    }
}

