/*
 * Decompiled with CFR 0.152.
 */
package jimm.util;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jimm.util.Replacer;

public class StringUtils {
    protected static final int DEFAULT_MAX_MESSAGE_WIDTH = 78;

    public static List split(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 == null) {
            arrayList.add(string);
            return arrayList;
        }
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            arrayList.add(string.substring(n2, n));
            n2 = n + n3;
        }
        if (n2 <= string.length()) {
            arrayList.add(string.substring(n2));
        }
        return arrayList;
    }

    public static String join(Collection collection, String string) {
        if (collection == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    public static List splitIntoLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        if (n == 0) {
            arrayList.add("");
            return arrayList;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\r') {
                int n3 = 1;
                if (i + 1 < n && string.charAt(i + 1) == '\n') {
                    n3 = 2;
                }
                arrayList.add(string.substring(n2, i));
                n2 = i + n3;
                if (n3 != 2) continue;
                ++i;
                continue;
            }
            if (c != '\n') continue;
            arrayList.add(string.substring(n2, i));
            n2 = i + 1;
        }
        if (n2 < n) {
            arrayList.add(string.substring(n2));
        }
        return arrayList;
    }

    public static void splitUp(StringBuffer stringBuffer, String string) {
        StringUtils.splitUp(stringBuffer, string, 78);
    }

    public static void splitUp(StringBuffer stringBuffer, String string, int n) {
        int n2;
        if (string == null) {
            return;
        }
        string = string.trim();
        while (string.length() >= n && ((n2 = string.lastIndexOf(32, n)) != -1 || (n2 = string.indexOf(32, n)) != -1)) {
            stringBuffer.append(string.substring(0, n2).trim());
            stringBuffer.append("\n");
            string = string.substring(n2 + 1).trim();
        }
        stringBuffer.append(string);
    }

    public static List wrap(String string, FontMetrics fontMetrics, int n) {
        List list = StringUtils.splitIntoLines(string);
        if (list.size() == 0) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StringUtils.wrapLineInto((String)iterator.next(), arrayList, fontMetrics, n);
        }
        return arrayList;
    }

    public static void wrapLineInto(String string, List list, FontMetrics fontMetrics, int n) {
        int n2;
        int n3 = string.length();
        while (n3 > 0 && (n2 = fontMetrics.stringWidth(string)) > n) {
            int n4;
            int n5 = n3 * n / n2;
            String string2 = string.substring(0, n5).trim();
            if ((n2 = fontMetrics.stringWidth(string2)) > n) {
                n4 = StringUtils.findBreakBefore(string, n5);
            } else {
                n4 = StringUtils.findBreakAfter(string, n5);
                if (n4 != -1 && fontMetrics.stringWidth(string2 = string.substring(0, n4).trim()) > n) {
                    n4 = StringUtils.findBreakBefore(string, n5);
                }
            }
            if (n4 == -1) {
                n4 = n5;
            }
            list.add(string.substring(0, n4).trim());
            string = string.substring(n4).trim();
            n3 = string.length();
        }
        if (n3 > 0) {
            list.add(string);
        }
    }

    public static int findBreakBefore(String string, int n) {
        for (int i = n; i >= 0; --i) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static int findBreakAfter(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c) && c != '-') continue;
            return i;
        }
        return -1;
    }

    public static String escapeHTML(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String newlinesToXHTMLBreaks(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\n<br />");
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < n && string.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    stringBuffer.append("\n<br />");
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String escapeXML(String string) {
        return StringUtils.escapeHTML(string);
    }

    public static String unescapeXML(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                int n2 = string.indexOf(";", i);
                if (n2 == -1) {
                    stringBuffer.append('&');
                    continue;
                }
                if (string.charAt(i + 1) == '#') {
                    int n3 = Integer.parseInt(string.substring(i + 2, n2), 16);
                    stringBuffer.append((char)n3);
                    i = n2;
                    continue;
                }
                String string2 = string.substring(i, n2 + 1);
                if (string2.equals("&amp;")) {
                    stringBuffer.append('&');
                } else if (string2.equals("&lt;")) {
                    stringBuffer.append('<');
                } else if (string2.equals("&gt;")) {
                    stringBuffer.append('>');
                } else if (string2.equals("&quot;")) {
                    stringBuffer.append('\"');
                } else if (string2.equals("&apos;")) {
                    stringBuffer.append('\'');
                } else {
                    stringBuffer.append(string2);
                }
                i = n2;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String replaceDelimited(String string, String string2, Replacer replacer, String string3) {
        return StringUtils.replaceDelimited(null, string, string2, replacer, string3);
    }

    public static String replaceDelimited(String string, String string2, String string3, Replacer replacer, String string4) {
        int n;
        int n2;
        int n3;
        if (string4 == null) {
            return null;
        }
        if (string2 == null || string3 == null || (n3 = string2.length()) == 0 || (n2 = string3.length()) == 0) {
            return string4;
        }
        int n4 = string == null ? 0 : string.length();
        String string5 = new String(string4);
        int n5 = 0;
        while ((n = string5.indexOf(string2, n5)) != -1) {
            int n6;
            if (n4 > 0 && (n6 = n - n4) >= 0 && string5.indexOf(string, n6) == n6) {
                n5 = n + 1;
                continue;
            }
            int n7 = string5.indexOf(string3, n + n3);
            if (n7 == -1) break;
            Object object = replacer.replace(string5.substring(n + n3, n7));
            if (object == null) {
                return null;
            }
            String string6 = object.toString();
            string5 = string5.substring(0, n) + string6 + string5.substring(n7 + n2);
            n5 = n + string6.length();
        }
        return string5;
    }

    public static String nullOrTrimmed(String string) {
        return string == null ? string : string.trim();
    }
}

