/*
 * Decompiled with CFR 0.152.
 */
package jimm.util;

import java.io.PrintWriter;

public class StopWatch {
    protected String name;
    protected long t0;
    protected long elapsedTime;
    protected PrintWriter out;

    public StopWatch() {
        this(null, null);
    }

    public StopWatch(String string) {
        this(string, null);
    }

    public StopWatch(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public StopWatch(String string, PrintWriter printWriter) {
        this.name = string;
        this.out = printWriter == null ? new PrintWriter(System.err) : printWriter;
        this.elapsedTime = -1L;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean bl) {
        if (this.t0 != 0L) {
            System.err.println("(warning: StopWatch already started; resetting)");
        }
        if (bl && this.name != null) {
            System.err.println("starting " + this.name);
        }
        this.elapsedTime = 0L;
        this.t0 = System.currentTimeMillis();
    }

    public void pause() {
        long l = System.currentTimeMillis();
        this.elapsedTime += l - this.t0;
        this.t0 = 0L;
    }

    public void resume() {
        this.t0 = System.currentTimeMillis();
    }

    public void mark() {
        this.stop(null, true);
    }

    public void mark(boolean bl) {
        this.stop(null, bl);
    }

    public void mark(String string) {
        this.stop(string, true);
    }

    public void mark(String string, boolean bl) {
        this.stop(string, bl);
    }

    public void stop() {
        this.stop(null, true);
    }

    public void stop(String string) {
        this.stop(string, true);
    }

    public void stop(String string, boolean bl) {
        long l = System.currentTimeMillis();
        if (this.elapsedTime == -1L) {
            System.err.println("(StopWatch" + (this.name != null ? " \"" + this.name + '\"' : "") + " was stopped without ever being started)");
            return;
        }
        long l2 = this.elapsedTime;
        if (this.t0 != 0L) {
            l2 += l - this.t0;
        }
        String string2 = null;
        if (bl && this.name != null) {
            System.err.print(this.name);
            string2 = ": ";
        }
        if (string != null) {
            if (string2 != null) {
                System.err.print(' ');
            }
            System.err.print("(" + string + ")");
            string2 = ": ";
        }
        if (string2 != null) {
            System.err.print(string2);
        }
        System.err.println("" + (double)l2 / 1000.0 + " seconds");
    }
}

