/*
 * Decompiled with CFR 0.152.
 */
package jimm.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18N {
    public static final String RESOURCE_FILE_PREFIX = "datavision";
    public static final String MENU_FILE_PREFIX = "menu";
    public static final String PAPER_FILE_PREFIX = "paper";
    protected static Locale locale;
    protected static HashMap bundles;

    public static void setLanguage(Locale locale) {
        if (!locale.equals(I18N.locale)) {
            I18N.locale = locale;
            bundles = new HashMap();
        }
    }

    public static String get(String string) {
        return I18N.get(RESOURCE_FILE_PREFIX, string);
    }

    public static String get(String string, String string2) {
        if (string2 == null || string == null || string.length() == 0) {
            return null;
        }
        if (string2.length() == 0) {
            return "";
        }
        String string3 = "";
        try {
            ResourceBundle resourceBundle = I18N.getBundle(string);
            string3 = resourceBundle.getString(string2);
            string3 = string3 == null ? string2 : string3.trim();
        }
        catch (MissingResourceException missingResourceException) {
            string3 = string2;
        }
        return string3;
    }

    public static String getNullIfMissing(String string) {
        return I18N.getNullIfMissing(RESOURCE_FILE_PREFIX, string);
    }

    public static String getNullIfMissing(String string, String string2) {
        if (string2 == null || string == null || string.length() == 0) {
            return null;
        }
        if (string2.length() == 0) {
            return "";
        }
        String string3 = null;
        try {
            ResourceBundle resourceBundle = I18N.getBundle(string);
            string3 = resourceBundle.getString(string2);
            string3 = string3 == null ? "" : string3.trim();
        }
        catch (MissingResourceException missingResourceException) {
            string3 = null;
        }
        return string3;
    }

    protected static ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(string, locale);
            bundles.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    static {
        I18N.setLanguage(Locale.getDefault());
    }
}

