/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import jimm.datavision.Subreport;
import jimm.datavision.source.Column;
import jimm.datavision.source.Join;
import jimm.datavision.source.sql.SQLQuery;
import jimm.util.XMLWriter;

public class SubreportQuery
extends SQLQuery {
    protected Subreport subreport;
    protected ArrayList subreportJoins;

    public SubreportQuery(Subreport subreport) {
        super(subreport);
        this.subreport = subreport;
        this.subreportJoins = new ArrayList();
    }

    public void addSubreportJoin(Join join) {
        this.subreportJoins.add(join);
    }

    public void addSubreportJoins(Collection collection) {
        this.subreportJoins.addAll(collection);
    }

    public Iterator parentColumns() {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Iterator iterator = this.subreportJoins.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Join)iterator.next()).getFrom());
        }
        return arrayList.iterator();
    }

    protected void buildWhereClause(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(" where ");
        if (!this.joins.isEmpty()) {
            this.buildJoins(stringBuffer);
            stringBuffer.append(" and ");
        }
        this.buildUserWhereClause(stringBuffer, bl);
    }

    public String getWhereClauseForDisplay() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.whereClause != null && this.whereClause.length() > 0) {
            stringBuffer.append('(');
            stringBuffer.append(super.getWhereClauseForPreparedStatement());
            stringBuffer.append(") and (");
        }
        Iterator iterator = this.subreportJoins.iterator();
        while (iterator.hasNext()) {
            Join join = (Join)iterator.next();
            stringBuffer.append(join.getFrom().fullName());
            stringBuffer.append(' ');
            stringBuffer.append(join.getRelation());
            stringBuffer.append(' ');
            stringBuffer.append(this.quoted(join.getTo().fullName()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" and ");
        }
        if (this.whereClause != null && this.whereClause.length() > 0) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String getWhereClauseForPreparedStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.whereClause != null && this.whereClause.length() > 0) {
            stringBuffer.append('(');
            stringBuffer.append(super.getWhereClauseForPreparedStatement());
            stringBuffer.append(") and (");
        }
        Iterator iterator = this.subreportJoins.iterator();
        while (iterator.hasNext()) {
            Join join = (Join)iterator.next();
            stringBuffer.append("? ");
            stringBuffer.append(join.getRelation());
            stringBuffer.append(' ');
            stringBuffer.append(this.quoted(join.getTo().fullName()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" and ");
        }
        if (this.whereClause != null && this.whereClause.length() > 0) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public void setParameters(PreparedStatement preparedStatement) throws SQLException {
        super.setParameters(preparedStatement);
        int n = this.preparedStmtValues.size() + 1;
        Iterator iterator = this.subreportJoins.iterator();
        while (iterator.hasNext()) {
            Column column = ((Join)iterator.next()).getFrom();
            Object object = this.subreport.getParentReport().columnValue(column);
            if (object instanceof Date) {
                preparedStatement.setDate(n, new java.sql.Date(((Date)object).getTime()));
            } else {
                preparedStatement.setObject(n, object);
            }
            ++n;
        }
    }

    protected void writeExtras(XMLWriter xMLWriter) {
        xMLWriter.startElement("subreport-joins");
        Iterator iterator = this.subreportJoins.iterator();
        while (iterator.hasNext()) {
            ((Join)iterator.next()).writeXML(xMLWriter);
        }
        xMLWriter.endElement();
    }
}

