/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source.sql;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jimm.datavision.Group;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.Subreport;
import jimm.datavision.Writeable;
import jimm.datavision.source.Column;
import jimm.datavision.source.Join;
import jimm.datavision.source.Query;
import jimm.datavision.source.Table;
import jimm.datavision.source.sql.Database;
import jimm.datavision.source.sql.ParserHelper;
import jimm.util.StringUtils;

public class SQLQuery
extends Query {
    protected Set tables = new HashSet();
    protected ArrayList preparedStmtValues;

    public SQLQuery(Report report) {
        super(report);
    }

    protected String getWhereClauseForPreparedStatement() {
        if (this.whereClause == null) {
            return null;
        }
        return this.prepare(this.whereClause);
    }

    public String prepare(String string) {
        if (string == null || string.indexOf("{") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = -1;
        while ((n = string.indexOf("{", n2 + 1)) >= 0) {
            int n3 = n2;
            n2 = string.indexOf("}", n);
            if (n2 == -1) {
                stringBuffer.append(string.substring(n));
                break;
            }
            switch (string.charAt(n + 1)) {
                case '@': {
                    String string2 = string.substring(n + 2, n2);
                    this.preparedStmtValues.add(this.report.findFormula(string2).eval());
                    stringBuffer.append(string.substring(n3 + 1, n));
                    stringBuffer.append(" ? ");
                    break;
                }
                case '?': {
                    String string2 = string.substring(n + 2, n2);
                    ParserHelper parserHelper = new ParserHelper(string, n);
                    stringBuffer.append(string.substring(n3 + 1, parserHelper.getEndBeforeToken()));
                    this.addParameter(stringBuffer, parserHelper.getPrevToken(), string2);
                    break;
                }
                default: {
                    stringBuffer.append(string.substring(n3 + 1, n));
                    stringBuffer.append(' ');
                    stringBuffer.append(this.quoted(string.substring(n + 1, n2)));
                    stringBuffer.append(' ');
                }
            }
            n = n2 + 1;
            n = n2 + 1;
        }
        if (n2 + 1 < string.length()) {
            stringBuffer.append(string.substring(n2 + 1));
        }
        return stringBuffer.toString();
    }

    protected void addParameter(StringBuffer stringBuffer, String string, String string2) {
        String string3 = null;
        Long l = new Long(string2);
        Parameter parameter = this.report.findParameter(l);
        Object object = this.report.getParameterValue(l);
        if (object instanceof List) {
            List list = (List)object;
            if (parameter.getArity() == 1) {
                if ("!=".equals(string) || "<>".equals(string)) {
                    stringBuffer.append(" not between ");
                } else if ("=".equals(string) || "in".equals(string.toLowerCase())) {
                    stringBuffer.append(" between ");
                } else {
                    stringBuffer.append(' ');
                    stringBuffer.append(string);
                    stringBuffer.append(' ');
                }
                string3 = "? and ?";
                this.preparedStmtValues.add(list.get(0));
                this.preparedStmtValues.add(list.get(1));
            } else {
                switch (list.size()) {
                    case 0: {
                        stringBuffer.append(" is null");
                        break;
                    }
                    case 1: {
                        if ("in".equals(string) || "<>".equals(string)) {
                            stringBuffer.append(" = ");
                        } else {
                            stringBuffer.append(' ');
                            stringBuffer.append(string);
                            stringBuffer.append(' ');
                        }
                        string3 = "?";
                        this.preparedStmtValues.add(list.get(0));
                        break;
                    }
                    default: {
                        if ("!=".equals(string) || "<>".equals(string)) {
                            stringBuffer.append(" not in ");
                        } else if ("=".equals(string) || "in".equals(string.toLowerCase())) {
                            stringBuffer.append(" in ");
                        } else {
                            stringBuffer.append(' ');
                            stringBuffer.append(string);
                            stringBuffer.append(' ');
                        }
                        StringBuffer stringBuffer2 = new StringBuffer("(");
                        boolean bl = true;
                        int n = list.size();
                        for (int i = 0; i < n; ++i) {
                            if (bl) {
                                bl = false;
                            } else {
                                stringBuffer2.append(',');
                            }
                            stringBuffer2.append('?');
                        }
                        stringBuffer2.append(")");
                        string3 = stringBuffer2.toString();
                        this.preparedStmtValues.addAll(list);
                        break;
                    }
                }
            }
        } else {
            stringBuffer.append(' ');
            stringBuffer.append(string);
            this.preparedStmtValues.add(object);
            string3 = " ?";
        }
        stringBuffer.append(string3);
    }

    protected void addParameterForDisplay(StringBuffer stringBuffer, String string, String string2) {
        String string3 = null;
        Long l = new Long(string2);
        Parameter parameter = this.report.findParameter(l);
        String string4 = parameter.designLabel();
        switch (parameter.getArity()) {
            case 1: {
                if ("!=".equals(string) || "<>".equals(string)) {
                    stringBuffer.append(" not between ");
                } else if ("=".equals(string) || "in".equals(string.toLowerCase())) {
                    stringBuffer.append(" between ");
                } else {
                    stringBuffer.append(' ');
                    stringBuffer.append(string);
                    stringBuffer.append(' ');
                }
                string3 = string4 + " and " + string4;
                break;
            }
            case 3: {
                if ("!=".equals(string) || "<>".equals(string)) {
                    stringBuffer.append(" not in ");
                } else if ("=".equals(string) || "in".equals(string.toLowerCase())) {
                    stringBuffer.append(" in ");
                } else {
                    stringBuffer.append(' ');
                    stringBuffer.append(string);
                    stringBuffer.append(' ');
                }
                string3 = "(" + string4 + ")";
                break;
            }
            default: {
                stringBuffer.append(' ');
                stringBuffer.append(string);
                string3 = " " + string4;
            }
        }
        stringBuffer.append(string3);
    }

    public void findSelectablesUsed() {
        Writeable writeable;
        super.findSelectablesUsed();
        this.tables.clear();
        Iterator iterator = this.selectables.iterator();
        while (iterator.hasNext()) {
            this.addTable(((Selectable)iterator.next()).getTable());
        }
        iterator = this.joins.iterator();
        while (iterator.hasNext()) {
            writeable = (Join)iterator.next();
            this.addTable(((Join)writeable).getFrom().getTable());
            this.addTable(((Join)writeable).getTo().getTable());
        }
        iterator = this.report.subreports();
        while (iterator.hasNext()) {
            writeable = (Subreport)iterator.next();
            Iterator iterator2 = ((Subreport)writeable).parentColumns();
            while (iterator2.hasNext()) {
                this.addTable(((Column)iterator2.next()).getTable());
            }
        }
    }

    protected void addTable(Table table) {
        if (table == null) {
            return;
        }
        String string = table.getName();
        Iterator iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            if (!((Table)iterator.next()).getName().equals(string)) continue;
            return;
        }
        this.tables.add(table);
    }

    public int getNumTables() {
        return this.tables.size();
    }

    public Collection getTablesUsed() {
        this.findSelectablesUsed();
        return this.tables;
    }

    protected String getWhereClauseForDisplay() {
        if (this.whereClause == null) {
            return null;
        }
        if (this.whereClause.indexOf("{") == -1) {
            return this.whereClause;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = -1;
        while ((n = this.whereClause.indexOf("{", n2 + 1)) >= 0) {
            int n3 = n2;
            n2 = this.whereClause.indexOf("}", n);
            if (n2 == -1) {
                stringBuffer.append(this.whereClause.substring(n));
                break;
            }
            switch (this.whereClause.charAt(n + 1)) {
                case '@': {
                    String string = this.whereClause.substring(n + 2, n2);
                    stringBuffer.append(this.whereClause.substring(n3 + 1, n));
                    stringBuffer.append(" {@");
                    stringBuffer.append(this.report.findFormula(string).getName());
                    stringBuffer.append("} ");
                    break;
                }
                case '?': {
                    String string = this.whereClause.substring(n + 2, n2);
                    ParserHelper parserHelper = new ParserHelper(this.whereClause, n);
                    stringBuffer.append(this.whereClause.substring(n3 + 1, parserHelper.getEndBeforeToken()));
                    this.addParameterForDisplay(stringBuffer, parserHelper.getPrevToken(), string);
                    break;
                }
                default: {
                    stringBuffer.append(this.whereClause.substring(n3 + 1, n));
                    stringBuffer.append(' ');
                    stringBuffer.append(this.quoted(this.whereClause.substring(n + 1, n2)));
                    stringBuffer.append(' ');
                }
            }
            n = n2 + 1;
            n = n2 + 1;
        }
        if (n2 + 1 < this.whereClause.length()) {
            stringBuffer.append(this.whereClause.substring(n2 + 1));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.queryAsString(true);
    }

    public String toPreparedStatementString() {
        this.preparedStmtValues = new ArrayList();
        return this.queryAsString(false);
    }

    protected String queryAsString(boolean bl) {
        this.findSelectablesUsed();
        if (this.tables.size() == 0 || this.selectables.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.buildSelect(stringBuffer);
        this.buildFrom(stringBuffer);
        this.buildWhereClause(stringBuffer, bl);
        this.buildOrderBy(stringBuffer);
        return stringBuffer.toString();
    }

    protected void buildSelect(StringBuffer stringBuffer) {
        stringBuffer.append("select ");
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.selectables.iterator();
        while (iterator.hasNext()) {
            String string = ((Selectable)iterator.next()).getSelectString(this);
            if (string == null) continue;
            arrayList.add(string);
        }
        stringBuffer.append(StringUtils.join(arrayList, ", "));
    }

    protected void buildFrom(StringBuffer stringBuffer) {
        stringBuffer.append(" from ");
        boolean bl = true;
        Iterator iterator = this.tables.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.quoted(((Table)iterator.next()).getName()));
        }
    }

    protected void buildWhereClause(StringBuffer stringBuffer, boolean bl) {
        if (this.joins.isEmpty() && (this.whereClause == null || this.whereClause.length() == 0)) {
            return;
        }
        stringBuffer.append(" where ");
        if (!this.joins.isEmpty()) {
            this.buildJoins(stringBuffer);
        }
        if (this.whereClause != null && this.whereClause.length() > 0) {
            if (!this.joins.isEmpty()) {
                stringBuffer.append(" and ");
            }
            this.buildUserWhereClause(stringBuffer, bl);
        }
    }

    protected void buildJoins(StringBuffer stringBuffer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.joins.iterator();
        while (iterator.hasNext()) {
            Join join = (Join)iterator.next();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(this.quoted(join.getFrom().fullName()));
            stringBuffer2.append(' ');
            stringBuffer2.append(join.getRelation());
            stringBuffer2.append(' ');
            stringBuffer2.append(this.quoted(join.getTo().fullName()));
            arrayList.add(stringBuffer2.toString());
        }
        stringBuffer.append("(");
        stringBuffer.append(StringUtils.join(arrayList, ") and ("));
        stringBuffer.append(")");
    }

    protected void buildUserWhereClause(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append("(");
        if (bl) {
            stringBuffer.append(this.getWhereClauseForDisplay());
        } else {
            stringBuffer.append(this.getWhereClauseForPreparedStatement());
        }
        stringBuffer.append(")");
    }

    protected void buildOrderBy(StringBuffer stringBuffer) {
        if (this.report.hasGroups() || !this.sortSelectables.isEmpty()) {
            CharSequence charSequence;
            Object object;
            stringBuffer.append(" order by ");
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.report.groups();
            while (iterator.hasNext()) {
                object = (Group)iterator.next();
                charSequence = new StringBuffer(((Group)object).getSortString(this));
                switch (((Group)object).getSortOrder()) {
                    case 0: {
                        charSequence.append(" asc");
                        break;
                    }
                    case 1: {
                        charSequence.append(" desc");
                    }
                }
                arrayList.add(charSequence.toString());
            }
            iterator = this.sortedSelectables();
            while (iterator.hasNext()) {
                object = (Selectable)iterator.next();
                charSequence = this.sortOrderOf((Selectable)object) == 0 ? "desc" : "asc";
                arrayList.add(object.getSortString(this) + ' ' + (String)charSequence);
            }
            stringBuffer.append(StringUtils.join(arrayList, ", "));
        }
    }

    public void setParameters(PreparedStatement preparedStatement) throws SQLException {
        int n = 1;
        Iterator iterator = this.preparedStmtValues.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof java.util.Date) {
                preparedStatement.setDate(n, new Date(((java.util.Date)e).getTime()));
            } else {
                preparedStatement.setObject(n, e);
            }
            ++n;
        }
    }

    public String quoted(String string) {
        Database database = (Database)this.report.getDataSource();
        List list = StringUtils.split(string, ".");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)list.get(i);
            if (string2.indexOf(" ") < 0 && (!this.report.caseSensitiveDatabaseNames() || (!database.storesLowerCaseIdentifiers() || string2.equals(string2.toLowerCase())) && (!database.storesUpperCaseIdentifiers() || string2.equals(string2.toUpperCase())))) continue;
            list.set(i, "\"" + string2 + "\"");
        }
        return StringUtils.join(list, ".");
    }
}

