/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jimm.datavision.ErrorHandler;
import jimm.datavision.source.DataCursor;
import jimm.datavision.source.sql.SQLQuery;

public class ResultSetRow
extends DataCursor {
    protected PreparedStatement stmt;
    protected ResultSet rset;
    protected int numSelectables;
    protected boolean noMoreData;

    ResultSetRow(Connection connection, SQLQuery sQLQuery) throws SQLException {
        String string = sQLQuery.toPreparedStatementString();
        if (string != null && string.length() > 0) {
            this.stmt = connection.prepareStatement(string);
            sQLQuery.setParameters(this.stmt);
            this.rset = this.stmt.executeQuery();
            this.numSelectables = sQLQuery.getNumSelectables();
            this.noMoreData = false;
        } else {
            this.numSelectables = 0;
            this.noMoreData = true;
        }
    }

    public List readRowData() {
        if (this.noMoreData) {
            return null;
        }
        try {
            if (!this.rset.next()) {
                this.noMoreData = true;
                return null;
            }
        }
        catch (SQLException sQLException) {
            ErrorHandler.error(sQLException);
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            for (int i = 1; i <= this.numSelectables; ++i) {
                arrayList.add(this.rset.getObject(i));
            }
        }
        catch (SQLException sQLException) {
            ErrorHandler.error(sQLException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.rset != null) {
                this.rset.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException sQLException) {
            ErrorHandler.error(sQLException);
        }
        finally {
            this.rset = null;
            this.stmt = null;
        }
    }
}

