/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.UserCancellationException;
import jimm.datavision.source.Column;
import jimm.datavision.source.ColumnIterator;
import jimm.datavision.source.DataCursor;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.Table;
import jimm.datavision.source.sql.ResultSetRow;
import jimm.datavision.source.sql.SQLQuery;
import jimm.datavision.source.sql.SQLTable;
import jimm.util.I18N;
import jimm.util.XMLWriter;

public class Database
extends DataSource {
    protected static final String[] DB_OBJECT_TYPES = new String[]{"TABLE", "VIEW"};
    protected String driverClassName;
    protected String connInfo;
    protected String name;
    protected String username;
    protected TreeMap tables;
    protected HashMap tableCacheMap;
    protected String schemaName;
    protected Connection conn;
    private String password;
    protected boolean hasPassword;
    protected boolean connectionOwnedByMe;
    protected boolean storesLowerCaseIdentifiers;
    protected boolean storesUpperCaseIdentifiers;

    public Database(Connection connection, Report report) throws SQLException {
        super(report, new SQLQuery(report));
        this.driverClassName = "";
        this.connInfo = "";
        this.name = "";
        this.username = "";
        this.password = "";
        this.hasPassword = true;
        this.tables = null;
        this.conn = connection;
        this.connectionOwnedByMe = false;
        this.loadAllTables();
    }

    public Database(String string, String string2, Report report, String string3, String string4) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, UserCancellationException {
        this(string, string2, report, string3, string4, null, false);
    }

    public Database(String string, String string2, Report report, String string3, String string4, String string5) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, UserCancellationException {
        this(string, string2, report, string3, string4, string5, true);
    }

    protected Database(String string, String string2, Report report, String string3, String string4, String string5, boolean bl) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, UserCancellationException {
        super(report, new SQLQuery(report));
        this.driverClassName = string;
        this.connInfo = string2;
        this.name = string3;
        this.username = string4 == null ? "" : string4;
        this.password = string5;
        this.tables = null;
        this.hasPassword = bl;
        this.initializeConnection();
        this.loadAllTables();
    }

    public boolean canJoinTables() {
        return true;
    }

    public boolean isSQLGenerated() {
        return true;
    }

    public boolean isConnectionEditable() {
        return true;
    }

    public boolean areRecordsSelectable() {
        return true;
    }

    public boolean areRecordsSortable() {
        return true;
    }

    public boolean canGroupRecords() {
        return true;
    }

    public Column findColumn(Object object) {
        int n;
        if (this.tables == null) {
            return null;
        }
        String string = object.toString();
        String string2 = string.substring(0, n = string.lastIndexOf(46));
        Table table = this.findTable(string2);
        return table == null ? null : table.findColumn(object);
    }

    protected Table findTable(String string) {
        Table table = (Table)this.tableCacheMap.get(string);
        if (table != null) {
            return table;
        }
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(46);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if (!this.getReport().caseSensitiveDatabaseNames()) {
            if (string3 != null) {
                string3 = string3.toLowerCase();
            }
            string = string.toLowerCase();
        }
        if (string3 != null && (table = this.findTableWithId(string3 + '.' + string)) != null) {
            this.tableCacheMap.put(string2, table);
            return table;
        }
        if (this.name != null) {
            String string4 = this.name;
            if (!this.getReport().caseSensitiveDatabaseNames()) {
                string4 = string4.toLowerCase();
            }
            if (!string4.equals(string3) && (table = this.findTableWithId(string4 + '.' + string)) != null) {
                this.tableCacheMap.put(string2, table);
                return table;
            }
        }
        if ((table = this.findTableWithId(string)) != null) {
            this.tableCacheMap.put(string2, table);
            return table;
        }
        return null;
    }

    protected Table findTableWithId(String string) {
        boolean bl = this.getReport().caseSensitiveDatabaseNames();
        Iterator iterator = this.tables.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equals(string) && (bl || !string2.equalsIgnoreCase(string))) continue;
            return (Table)this.tables.get(string2);
        }
        return null;
    }

    public Iterator tables() {
        return this.tables.values().iterator();
    }

    public Iterator tablesUsedInReport() {
        return ((SQLQuery)this.query).getTablesUsed().iterator();
    }

    public Iterator columns() {
        return new ColumnIterator(this.tables.values().iterator());
    }

    public DataCursor execute() throws SQLException {
        return new ResultSetRow(this.conn, (SQLQuery)this.query);
    }

    public boolean storesLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    public boolean storesUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    public void initializeConnection() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UserCancellationException {
        boolean bl = false;
        while (!bl) {
            if (!this.hasPassword) {
                this.report.askForPassword(this);
                this.hasPassword = true;
            }
            if (this.password == null) {
                throw new UserCancellationException(I18N.get("Database.cancelled"));
            }
            try {
                if (this.connInfo == null || this.connInfo.length() == 0) {
                    throw new IllegalArgumentException(I18N.get("Database.missing_conn_info"));
                }
                if (this.username == null || this.username.length() == 0) {
                    throw new IllegalArgumentException(I18N.get("Database.missing_user_name"));
                }
                if (this.password == null) {
                    throw new IllegalArgumentException(I18N.get("Database.null_password"));
                }
                Driver driver = (Driver)Class.forName(this.driverClassName).newInstance();
                DriverManager.registerDriver(driver);
                this.conn = DriverManager.getConnection(this.connInfo, this.username, this.password);
                this.connectionOwnedByMe = true;
                bl = true;
            }
            catch (SQLException sQLException) {
                ErrorHandler.error(sQLException);
                this.hasPassword = false;
                this.report.setDatabasePassword(null);
            }
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void reset(String string, String string2, String string3, String string4, String string5) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, UserCancellationException {
        this.setDriverClassName(string);
        this.setConnectionInfo(string2);
        this.setName(string3);
        this.setUserName(string4);
        this.password = string5;
        this.hasPassword = true;
        if (this.conn != null) {
            if (this.connectionOwnedByMe) {
                this.conn.close();
            }
            this.conn = null;
        }
        this.initializeConnection();
        this.loadAllTables();
        this.report.reloadColumns();
    }

    protected void loadAllTables() throws SQLException {
        this.tables = new TreeMap();
        this.tableCacheMap = new HashMap();
        this.schemaName = null;
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        this.storesLowerCaseIdentifiers = databaseMetaData.storesLowerCaseIdentifiers();
        this.storesUpperCaseIdentifiers = databaseMetaData.storesUpperCaseIdentifiers();
        try {
            this.loadTablesUsingSchemaNameAndTypes(databaseMetaData, this.name, DB_OBJECT_TYPES);
        }
        catch (SQLException sQLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (this.tables.isEmpty() && this.name != null) {
                this.loadTablesUsingSchemaNameAndTypes(databaseMetaData, this.name, null);
            }
        }
        catch (SQLException sQLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            if (this.tables.isEmpty()) {
                this.loadTablesUsingSchemaNameAndTypes(databaseMetaData, null, DB_OBJECT_TYPES);
            }
        }
        catch (SQLException sQLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.tables.isEmpty()) {
            this.loadTablesUsingSchemaNameAndTypes(databaseMetaData, null, null);
        }
    }

    protected void loadTablesUsingSchemaNameAndTypes(DatabaseMetaData databaseMetaData, String string, String[] stringArray) throws SQLException {
        ResultSet resultSet = databaseMetaData.getTables(null, string, "%", stringArray);
        if (resultSet == null) {
            return;
        }
        boolean bl = false;
        while (resultSet.next()) {
            String string2 = resultSet.getString("TABLE_NAME").trim();
            if (!bl) {
                try {
                    this.schemaName = resultSet.getString("TABLE_SCHEM");
                }
                catch (SQLException sQLException) {
                    bl = true;
                }
                if (this.schemaName != null && this.schemaName.length() > 0) {
                    string2 = this.schemaName.trim() + '.' + string2;
                }
            }
            SQLTable sQLTable = new SQLTable(this, string2, databaseMetaData);
            this.tables.put(sQLTable.getId().toString(), sQLTable);
        }
        resultSet.close();
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    protected void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public String getConnectionInfo() {
        return this.connInfo;
    }

    protected void setConnectionInfo(String string) {
        this.connInfo = string;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.hasPassword ? this.password : null;
    }

    public void setPassword(String string) {
        this.password = string;
        this.hasPassword = true;
    }

    protected void doWriteXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("database");
        xMLWriter.attr("driverClassName", this.driverClassName);
        xMLWriter.attr("connInfo", this.connInfo);
        xMLWriter.attr("name", this.name);
        xMLWriter.attr("username", this.username);
        xMLWriter.endElement();
    }
}

