/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source.ncsql;

import java.util.Iterator;
import java.util.TreeMap;
import jimm.datavision.Report;
import jimm.datavision.source.Column;
import jimm.datavision.source.ColumnIterator;
import jimm.datavision.source.DataCursor;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.Table;
import jimm.datavision.source.ncsql.NCColumn;
import jimm.datavision.source.ncsql.NCQuery;
import jimm.datavision.source.ncsql.NCTable;
import jimm.util.XMLWriter;

public class NCDatabase
extends DataSource {
    protected static final String ORPHANS_TABLE = "no_table";
    protected TreeMap tables = new TreeMap();

    public NCDatabase(Report report) {
        super(report, new NCQuery(report));
    }

    public boolean canRunReports() {
        return false;
    }

    public boolean canJoinTables() {
        return true;
    }

    public boolean isSQLGenerated() {
        return true;
    }

    public boolean isConnectionEditable() {
        return false;
    }

    public boolean areRecordsSelectable() {
        return true;
    }

    public boolean areRecordsSortable() {
        return true;
    }

    public boolean canGroupRecords() {
        return true;
    }

    public void addColumn(Column column) {
        String string = column.fullName();
        int n = string.lastIndexOf(46);
        String string2 = null;
        String string3 = null;
        if (n == -1) {
            string2 = ORPHANS_TABLE;
            string3 = string;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        NCTable nCTable = (NCTable)this.tables.get(string2);
        if (nCTable == null) {
            nCTable = new NCTable(this, string2);
            this.tables.put(string2, nCTable);
        }
        nCTable.addColumn(new NCColumn(nCTable, string3, column.getType()));
    }

    public Column findColumn(Object object) {
        if (this.tables == null) {
            return null;
        }
        Iterator iterator = this.tables.values().iterator();
        while (iterator.hasNext()) {
            Column column = ((Table)iterator.next()).findColumn(object);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    public Iterator tables() {
        return this.tables.values().iterator();
    }

    public Iterator tablesUsedInReport() {
        return ((NCQuery)this.query).getTablesUsed().iterator();
    }

    public Iterator columns() {
        return new ColumnIterator(this.tables.values().iterator());
    }

    public DataCursor execute() {
        return null;
    }

    protected void doWriteXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("nc-database");
        if (this.metadataURL != null) {
            xMLWriter.textElement("metadata-url", this.metadataURL);
        } else {
            Iterator iterator = this.columns();
            while (iterator.hasNext()) {
                ((Column)iterator.next()).writeXML(xMLWriter);
            }
        }
        xMLWriter.endElement();
    }
}

