/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source.charsep;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataCursor;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.charsep.CharSepQuery;
import jimm.datavision.source.charsep.CharSepRow;
import jimm.util.XMLWriter;

public class CharSepSource
extends DataSource {
    protected static final char DEFAULT_SEP_CHAR = ',';
    protected ArrayList columns = new ArrayList();
    protected char sepChar = (char)44;
    protected BufferedReader reader;
    protected String sourceFilePath;

    public CharSepSource(Report report) {
        super(report, new CharSepQuery(report));
    }

    public boolean canJoinTables() {
        return true;
    }

    public boolean isSQLGenerated() {
        return false;
    }

    public boolean isConnectionEditable() {
        return false;
    }

    public boolean areRecordsSelectable() {
        return true;
    }

    public boolean areRecordsSortable() {
        return false;
    }

    public boolean canGroupRecords() {
        return false;
    }

    public boolean needsSourceFile() {
        return true;
    }

    public void setSourceFile(String string) throws FileNotFoundException {
        this.sourceFilePath = string;
        this.reuseSourceFile();
    }

    public void reuseSourceFile() throws FileNotFoundException {
        this.setInput(new FileReader(this.sourceFilePath));
    }

    public void setInput(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public void setInput(InputStreamReader inputStreamReader) {
        this.reader = new BufferedReader(inputStreamReader);
    }

    public void setInput(String string) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(string));
    }

    public char getSepChar() {
        return this.sepChar;
    }

    public void setSepChar(char c) {
        this.sepChar = c;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
        ((CharSepQuery)this.query).addColumn(column);
    }

    public Column findColumn(Object object) {
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!column.getId().equals(object)) continue;
            return column;
        }
        return null;
    }

    public int indexOfSelectable(Selectable selectable) {
        return this.columns.indexOf(selectable);
    }

    public Iterator tables() {
        return null;
    }

    public Iterator tablesUsedInReport() {
        return null;
    }

    public Iterator columns() {
        return this.columns.iterator();
    }

    public DataCursor execute() {
        return new CharSepRow(this, this.query);
    }

    BufferedReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeReader() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            ErrorHandler.error(iOException);
        }
        finally {
            this.reader = null;
        }
    }

    protected void doWriteXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("charsep");
        xMLWriter.attr("sepchar", this.sepChar);
        if (this.metadataURL != null) {
            xMLWriter.textElement("metadata-url", this.metadataURL);
        } else {
            Iterator iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                ((Column)iterator.next()).writeXML(xMLWriter);
            }
        }
        xMLWriter.endElement();
    }
}

