/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source.charsep;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Formula;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataCursor;
import jimm.datavision.source.Query;
import jimm.datavision.source.charsep.CharSepSource;
import jimm.datavision.source.charsep.DelimParser;

public class CharSepRow
extends DataCursor {
    protected CharSepSource source;
    protected Query query;
    protected Formula whereClauseFormula;
    protected boolean noMoreData;
    protected DelimParser parser;
    protected HashMap dateParsers;
    protected boolean dateParseErrorReported;

    CharSepRow(CharSepSource charSepSource, Query query) {
        this.source = charSepSource;
        this.query = query;
        this.query.findSelectablesUsed();
        String string = query.getWhereClause();
        if (string != null && string.length() > 0) {
            this.whereClauseFormula = new Formula(null, charSepSource.getReport(), "", string);
        }
    }

    public List readRowData() {
        boolean bl;
        if (this.noMoreData) {
            return null;
        }
        List list = null;
        do {
            list = this.retrieveNextRow();
            if (this.whereClauseFormula != null && list != null) {
                List list2 = this.currRowData;
                this.currRowData = list;
                Object object = this.whereClauseFormula.eval();
                bl = (Boolean)object;
                this.currRowData = list2;
                continue;
            }
            bl = true;
        } while (!bl);
        return list;
    }

    protected List retrieveNextRow() {
        if (this.parser == null) {
            this.parser = new DelimParser(this.source.getReader(), this.source.getSepChar());
        }
        List list = null;
        try {
            list = this.parser.parse();
        }
        catch (IOException iOException) {
            ErrorHandler.error(iOException);
            this.noMoreData = true;
            return null;
        }
        if (list == null) {
            this.noMoreData = true;
            return null;
        }
        int n = list.size();
        int n2 = 0;
        Iterator iterator = this.source.columns();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (n2 >= n) {
                list.add(null);
            } else if (column.isNumeric()) {
                String string = list.get(n2).toString();
                if (string == null || string.length() == 0) {
                    list.set(n2, new Integer(0));
                } else if (string.indexOf(46) == -1) {
                    list.set(n2, new Integer(string));
                } else {
                    list.set(n2, new Double(string));
                }
            } else if (column.isDate()) {
                list.set(n2, this.parseDate(column, list.get(n2).toString()));
            }
            ++n2;
        }
        return list;
    }

    protected Date parseDate(Column column, String string) {
        SimpleDateFormat simpleDateFormat;
        String string2 = column.getDateParseFormat();
        if (this.dateParsers == null) {
            this.dateParsers = new HashMap();
        }
        if ((simpleDateFormat = (SimpleDateFormat)this.dateParsers.get(string2)) == null) {
            simpleDateFormat = new SimpleDateFormat(string2);
            this.dateParsers.put(string2, simpleDateFormat);
        }
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            if (!this.dateParseErrorReported) {
                ErrorHandler.error("Parse format string = " + string2, parseException);
                this.dateParseErrorReported = true;
            }
            return null;
        }
    }

    public void close() {
        this.source.closeReader();
    }
}

