/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jimm.datavision.Expression;
import jimm.datavision.FieldWalker;
import jimm.datavision.Formula;
import jimm.datavision.Group;
import jimm.datavision.ListWriter;
import jimm.datavision.Nameable;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.Subreport;
import jimm.datavision.UserColumn;
import jimm.datavision.Writeable;
import jimm.datavision.field.ColumnField;
import jimm.datavision.field.Field;
import jimm.datavision.field.FormulaField;
import jimm.datavision.field.UserColumnField;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.Join;
import jimm.util.XMLWriter;

public class Query
implements Writeable {
    public static final int SORT_UNDEFINED = -1;
    public static final int SORT_DESCENDING = 0;
    public static final int SORT_ASCENDING = 1;
    protected Report report;
    protected ArrayList joins;
    protected String whereClause;
    protected ArrayList sortSelectables;
    protected ArrayList sortOrders;
    protected ArrayList selectables;

    public Query(Report report) {
        this.report = report;
        this.joins = new ArrayList();
        this.whereClause = null;
        this.sortSelectables = new ArrayList();
        this.sortOrders = new ArrayList();
        this.selectables = new ArrayList();
    }

    public boolean containsReferenceTo(Parameter parameter) {
        if (this.whereClause == null || this.whereClause.indexOf("{") == -1) {
            return false;
        }
        int n = 0;
        int n2 = -1;
        while ((n = this.whereClause.indexOf("{", n2 + 1)) >= 0) {
            n2 = this.whereClause.indexOf("}", n);
            if (n2 == -1) {
                return false;
            }
            switch (this.whereClause.charAt(n + 1)) {
                case '@': {
                    String string = this.whereClause.substring(n + 2, n2);
                    Formula formula = this.report.findFormula(string);
                    if (!formula.refersTo(parameter)) break;
                    return true;
                }
                case '?': {
                    String string = this.whereClause.substring(n + 2, n2);
                    if (!parameter.getId().toString().equals(string)) break;
                    return true;
                }
            }
            n = n2 + 1;
            n = n2 + 1;
        }
        return false;
    }

    public void addJoin(Join join) {
        this.joins.add(join);
    }

    public void addAllJoins(Collection collection) {
        this.joins.addAll(collection);
    }

    public void removeJoin(Join join) {
        this.joins.remove(join);
    }

    public void clearJoins() {
        this.joins.clear();
    }

    public Iterator joins() {
        return this.joins.iterator();
    }

    public String getEditableWhereClause() {
        return Expression.expressionToDisplay(this.report, this.whereClause);
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setEditableWhereClause(String string) {
        this.setWhereClause(Expression.displayToExpression(this.report, string));
    }

    public void setWhereClause(String string) {
        this.whereClause = string;
    }

    public void addSort(Selectable selectable, int n) {
        this.sortSelectables.add(selectable);
        this.sortOrders.add(new Integer(n));
    }

    public void removeSort(Selectable selectable) {
        for (int i = 0; i < this.sortSelectables.size(); ++i) {
            if (this.sortSelectables.get(i) != selectable) continue;
            this.sortSelectables.remove(i);
            this.sortOrders.remove(i);
            return;
        }
    }

    public void clearSorts() {
        this.sortSelectables = new ArrayList();
        this.sortOrders = new ArrayList();
    }

    public Iterator selectables() {
        return this.selectables.iterator();
    }

    public Iterator sortedSelectables() {
        return this.sortSelectables.iterator();
    }

    public int sortOrderOf(Selectable selectable) {
        for (int i = 0; i < this.sortSelectables.size(); ++i) {
            if (this.sortSelectables.get(i) != selectable) continue;
            return (Integer)this.sortOrders.get(i);
        }
        return -1;
    }

    public int indexOfSelectable(Selectable selectable) {
        return this.selectables.indexOf(selectable);
    }

    public void findSelectablesUsed() {
        Object object;
        Object object2;
        this.selectables.clear();
        this.report.withFieldsDo(new FieldWalker(){

            public void step(Field field) {
                UserColumn userColumn;
                if (field instanceof ColumnField) {
                    Column column = ((ColumnField)field).getColumn();
                    if (!Query.this.selectables.contains(column)) {
                        Query.this.selectables.add(column);
                    }
                } else if (field instanceof FormulaField) {
                    Nameable nameable;
                    FormulaField formulaField = (FormulaField)field;
                    Iterator iterator = formulaField.columnsUsed().iterator();
                    while (iterator.hasNext()) {
                        nameable = (Column)iterator.next();
                        if (Query.this.selectables.contains(nameable)) continue;
                        Query.this.selectables.add(nameable);
                    }
                    iterator = formulaField.userColumnsUsed().iterator();
                    while (iterator.hasNext()) {
                        nameable = (UserColumn)iterator.next();
                        if (Query.this.selectables.contains(nameable)) continue;
                        Query.this.selectables.add(nameable);
                    }
                } else if (field instanceof UserColumnField && !Query.this.selectables.contains(userColumn = ((UserColumnField)field).getUserColumn())) {
                    Query.this.selectables.add(userColumn);
                }
            }
        });
        Iterator iterator = this.report.groups();
        while (iterator.hasNext()) {
            object2 = (Group)iterator.next();
            object = ((Group)object2).getSelectable();
            if (this.selectables.contains(object)) continue;
            this.selectables.add(object);
        }
        iterator = this.sortedSelectables();
        while (iterator.hasNext()) {
            object2 = (Selectable)iterator.next();
            if (this.selectables.contains(object2)) continue;
            this.selectables.add(object2);
        }
        iterator = this.report.subreports();
        while (iterator.hasNext()) {
            object2 = (Subreport)iterator.next();
            object = ((Subreport)object2).parentColumns();
            while (object.hasNext()) {
                Column column = (Column)object.next();
                if (this.selectables.contains(column)) continue;
                this.selectables.add(column);
            }
        }
    }

    public int getNumSelectables() {
        return this.selectables.size();
    }

    public void reloadColumns(DataSource dataSource) {
        Object object;
        ArrayList<Selectable> arrayList;
        Object object2 = this.joins();
        while (object2.hasNext()) {
            arrayList = (Join)object2.next();
            ((Join)((Object)arrayList)).setFrom(dataSource.findColumn(((Join)((Object)arrayList)).getFrom().getId()));
            ((Join)((Object)arrayList)).setTo(dataSource.findColumn(((Join)((Object)arrayList)).getTo().getId()));
        }
        object2 = new ArrayList();
        arrayList = this.selectables.iterator();
        while (arrayList.hasNext()) {
            object = (Selectable)arrayList.next();
            ((ArrayList)object2).add(object.reloadInstance(dataSource));
        }
        this.selectables = object2;
        arrayList = new ArrayList<Selectable>();
        object = this.sortSelectables.iterator();
        while (object.hasNext()) {
            Selectable selectable = (Selectable)object.next();
            arrayList.add(selectable.reloadInstance(dataSource));
        }
        this.sortSelectables = arrayList;
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("query");
        ListWriter.writeList(xMLWriter, this.joins);
        if (this.whereClause != null && this.whereClause.length() > 0) {
            xMLWriter.cdataElement("where", this.whereClause);
        }
        for (int i = 0; i < this.sortSelectables.size(); ++i) {
            int n = (Integer)this.sortOrders.get(i);
            Selectable selectable = (Selectable)this.sortSelectables.get(i);
            xMLWriter.startElement("sort");
            xMLWriter.attr("order", n == 0 ? "desc" : "asc");
            xMLWriter.attr("groupable-id", selectable.getId());
            xMLWriter.attr("groupable-type", selectable.fieldTypeString());
            xMLWriter.endElement();
        }
        this.writeExtras(xMLWriter);
        xMLWriter.endElement();
    }

    protected void writeExtras(XMLWriter xMLWriter) {
    }
}

