/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Parameter;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.Writeable;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataCursor;
import jimm.datavision.source.MetadataReader;
import jimm.datavision.source.Query;
import jimm.datavision.source.Table;
import jimm.util.I18N;
import jimm.util.XMLWriter;
import org.xml.sax.InputSource;

public abstract class DataSource
implements Writeable {
    protected Report report;
    protected Query query;
    protected String metadataURL;

    public DataSource(Report report, Query query) {
        this.report = report;
        this.query = query;
    }

    public abstract boolean canJoinTables();

    public abstract boolean isSQLGenerated();

    public abstract boolean isConnectionEditable();

    public abstract boolean areRecordsSelectable();

    public abstract boolean areRecordsSortable();

    public abstract boolean canGroupRecords();

    public boolean canRunReports() {
        return true;
    }

    public boolean needsSourceFile() {
        return false;
    }

    public void setSourceFile(String string) throws FileNotFoundException {
    }

    public void reuseSourceFile() throws FileNotFoundException {
    }

    public Report getReport() {
        return this.report;
    }

    public Query getQuery() {
        return this.query;
    }

    public abstract DataCursor execute() throws Exception;

    public void addColumn(Column column) {
    }

    public void reloadColumns() {
        if (this.query != null) {
            this.query.reloadColumns(this);
        }
    }

    public void readMetadataFrom(String string) throws Exception {
        try {
            this.metadataURL = string;
            new MetadataReader(this).read(new InputSource(string));
        }
        catch (IOException iOException) {
            ErrorHandler.error(I18N.get("DataSource.metadata_err"), iOException, I18N.get("DataSource.metadata_err_title"));
        }
    }

    public abstract Column findColumn(Object var1);

    public int indexOfSelectable(Selectable selectable) {
        return this.query.indexOfSelectable(selectable);
    }

    public abstract Iterator tables();

    public abstract Iterator tablesUsedInReport();

    public abstract Iterator columns();

    public Iterator columnsInTablesUsedInReport() {
        Iterator iterator = this.tablesUsedInReport();
        if (iterator == null) {
            return this.columns();
        }
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            arrayList.addAll(table.columns.values());
        }
        return arrayList.iterator();
    }

    public void removeSort(Selectable selectable) {
        this.query.removeSort(selectable);
    }

    public boolean containsReferenceTo(Parameter parameter) {
        return this.query.containsReferenceTo(parameter);
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("source");
        this.doWriteXML(xMLWriter);
        this.query.writeXML(xMLWriter);
        xMLWriter.endElement();
    }

    protected abstract void doWriteXML(XMLWriter var1);
}

