/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source;

import java.util.List;

public abstract class DataCursor {
    protected int currRowNumber;
    protected List prevRowData;
    protected List currRowData;
    protected List nextRowData;
    protected List lastRowData;
    protected int lastRowNumber;

    public boolean isFirst() {
        return this.currRowNumber == 1;
    }

    public boolean isLast() {
        if (this.nextRowData != null) {
            return false;
        }
        this.nextRowData = this.readRowData();
        return this.nextRowData == null;
    }

    public boolean next() {
        if (this.nextRowData == null) {
            this.nextRowData = this.readRowData();
        }
        if (this.nextRowData == null) {
            this.lastRowData = this.currRowData;
            this.lastRowNumber = this.currRowNumber;
        }
        this.prevRowData = this.currRowData;
        this.currRowData = this.nextRowData;
        this.nextRowData = null;
        ++this.currRowNumber;
        return this.currRowData != null;
    }

    public boolean previous() {
        if (this.currRowNumber <= 1) {
            return false;
        }
        this.nextRowData = this.currRowData;
        this.currRowData = this.prevRowData;
        this.prevRowData = null;
        --this.currRowNumber;
        return true;
    }

    public boolean last() {
        while (this.lastRowData == null && this.next()) {
        }
        this.currRowData = this.lastRowData;
        this.currRowNumber = this.lastRowNumber;
        return true;
    }

    public int getRow() {
        return this.currRowNumber;
    }

    public void close() {
    }

    public Object getObject(int n) {
        return this.currRowData == null ? null : this.currRowData.get(n - 1);
    }

    protected abstract List readRowData();
}

