/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.source;

import jimm.datavision.Draggable;
import jimm.datavision.Identity;
import jimm.datavision.Nameable;
import jimm.datavision.Report;
import jimm.datavision.Selectable;
import jimm.datavision.Writeable;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.Table;
import jimm.datavision.source.sql.SQLQuery;
import jimm.util.XMLWriter;

public class Column
implements Identity,
Nameable,
Selectable,
Draggable,
Writeable {
    public static final String DEFAULT_DATE_PARSE_FORMAT = "yyyy-MM-dd";
    protected Object id;
    protected String name;
    protected int type;
    protected String dateParseFormat;

    public static int typeFromString(String string) {
        if (string == null || string.length() == 0) {
            return 12;
        }
        if ((string = string.toLowerCase()).equals("number")) {
            return 2;
        }
        if (string.equals("date")) {
            return 91;
        }
        return 12;
    }

    public static String typeToString(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return "number";
            }
            case 91: 
            case 92: 
            case 93: {
                return "date";
            }
        }
        return "string";
    }

    public Column(Object object, String string, int n) {
        this.id = object;
        this.name = string;
        this.type = n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Column)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.id.equals(((Column)object).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
    }

    public String getDateParseFormat() {
        return this.dateParseFormat == null ? DEFAULT_DATE_PARSE_FORMAT : this.dateParseFormat;
    }

    public void setDateParseFormat(String string) {
        this.dateParseFormat = string;
    }

    public Table getTable() {
        return null;
    }

    public String fullName() {
        return this.id.toString();
    }

    public int getType() {
        return this.type;
    }

    public Object getValue(Report report) {
        return report.columnValue(this);
    }

    public String fieldTypeString() {
        return "column";
    }

    public String getSelectString(SQLQuery sQLQuery) {
        return sQLQuery.quoted(this.fullName());
    }

    public String getSortString(SQLQuery sQLQuery) {
        return this.getSelectString(sQLQuery);
    }

    public String dragString() {
        return "column:" + this.fullName();
    }

    public String getDisplayName() {
        return this.fullName();
    }

    public Selectable reloadInstance(DataSource dataSource) {
        return dataSource.findColumn(this.getId());
    }

    public boolean isNumeric() {
        return this.type == -5 || this.type == -7 || this.type == 3 || this.type == 8 || this.type == 6 || this.type == 4 || this.type == 2 || this.type == 7 || this.type == 5 || this.type == -6;
    }

    public boolean isDate() {
        return this.type == 91 || this.type == 92 || this.type == 93;
    }

    public boolean isString() {
        return !this.isNumeric() && !this.isDate();
    }

    public String toString() {
        return this.fullName();
    }

    public void writeXML(XMLWriter xMLWriter) {
        xMLWriter.startElement("column");
        xMLWriter.attr("name", this.getName());
        xMLWriter.attr("type", Column.typeToString(this.type));
        if (this.dateParseFormat != null) {
            xMLWriter.attr("date-format", this.dateParseFormat);
        }
        xMLWriter.endElement();
    }
}

