/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout.swing;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.layout.swing.AbstractSwingField;

public class SwingTextField
extends AbstractSwingField {
    public static final Color HIDDEN_FG_COLOR = Color.gray;

    public SwingTextField(Field field) {
        this(field, field.toString());
    }

    public SwingTextField(Field field, String string) {
        super(field, new JTextPane());
        JTextPane jTextPane = (JTextPane)this.getComponent();
        jTextPane.setText(string);
        jTextPane.setEditable(false);
        this.format();
    }

    public void format() {
        JTextPane jTextPane = (JTextPane)this.getComponent();
        Format format = this.field.getFormat();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        int n = jTextPane.getSelectionStart();
        int n2 = jTextPane.getSelectionEnd();
        jTextPane.selectAll();
        StyleConstants.setBold(style, format.isBold());
        StyleConstants.setItalic(style, format.isItalic());
        StyleConstants.setUnderline(style, format.isUnderline());
        StyleConstants.setFontSize(style, (int)format.getSize());
        StyleConstants.setFontFamily(style, format.getFontFamilyName());
        StyleConstants.setForeground(style, this.getColor(format));
        switch (format.getAlign()) {
            case 1: {
                StyleConstants.setAlignment(style, 1);
                break;
            }
            case 2: {
                StyleConstants.setAlignment(style, 2);
                break;
            }
            default: {
                StyleConstants.setAlignment(style, 0);
            }
        }
        jTextPane.setParagraphAttributes(style, true);
        jTextPane.setCaretPosition(n);
        jTextPane.moveCaretPosition(n2);
        this.makeBorders();
    }

    public Color getColor() {
        return this.getColor(this.field.getFormat());
    }

    public Color getColor(Format format) {
        Color color = format.getColor();
        if (!this.field.isVisible()) {
            if (color.equals(Color.black)) {
                color = HIDDEN_FG_COLOR;
            } else {
                float[] fArray = new float[3];
                Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
                fArray[1] = 0.5f;
                fArray[2] = 0.9f;
                color = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
            }
        }
        return color;
    }
}

