/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout.swing;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.List;
import jimm.datavision.UserCancellationException;
import jimm.datavision.gui.StatusDialog;
import jimm.datavision.layout.swing.SwingPage;
import jimm.datavision.layout.swing.SwingPageContents;
import jimm.util.I18N;

class SwingPrintBook
implements Pageable {
    protected StatusDialog statusDialog;
    protected List pageContents;
    protected PageFormat pageFormat;
    protected boolean wasBuiltForUs;

    SwingPrintBook(List list, PageFormat pageFormat) {
        this.pageContents = list;
        this.pageFormat = pageFormat;
    }

    void setStatusDialog(StatusDialog statusDialog) {
        this.statusDialog = statusDialog;
    }

    public int getNumberOfPages() {
        return this.pageContents.size();
    }

    public PageFormat getPageFormat(int n) {
        return this.pageFormat;
    }

    public Printable getPrintable(int n) {
        SwingPageContents swingPageContents;
        if (this.wasBuiltForUs) {
            swingPageContents = (SwingPageContents)this.pageContents.get(n - 1);
            swingPageContents.forgetPage();
        }
        if (this.statusDialog.isCancelled()) {
            throw new UserCancellationException();
        }
        this.statusDialog.update(I18N.get("SwingPrintBook.printing_page") + ' ' + (n + 1) + ' ' + I18N.get("SwingPrintBook.of") + ' ' + this.getNumberOfPages());
        swingPageContents = (SwingPageContents)this.pageContents.get(n);
        SwingPage swingPage = null;
        swingPage = swingPageContents.getPage();
        this.wasBuiltForUs = !swingPageContents.isPageBuilt();
        return swingPage;
    }
}

