/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout.swing;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import jimm.datavision.ErrorHandler;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;
import jimm.datavision.layout.swing.AbstractSwingField;
import jimm.datavision.layout.swing.SwingImageField;
import jimm.datavision.layout.swing.SwingPage;
import jimm.datavision.layout.swing.SwingPageField;
import jimm.datavision.layout.swing.SwingTextField;

class SwingPageContents {
    ArrayList pageFields = new ArrayList();
    SwingPage page;
    int pageNumber;
    JPanel parent;
    Dimension pageDim;
    Thread buildThread;

    SwingPageContents(JPanel jPanel, int n, Dimension dimension) {
        this.pageNumber = n;
        this.parent = jPanel;
        this.pageDim = dimension;
    }

    void add(Field field, String string, Rectangle rectangle) {
        this.pageFields.add(new SwingPageField(field, string, rectangle));
    }

    boolean isPageBuilt() {
        return this.page != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SwingPage getPage() {
        block8: {
            if (this.page == null) {
                if (this.buildThread != null) {
                    try {
                        if (this.buildThread == null) break block8;
                        Thread thread = this.buildThread;
                        synchronized (thread) {
                            this.buildThread.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ErrorHandler.error(interruptedException);
                    }
                } else {
                    this.buildPage();
                }
            }
        }
        return this.page;
    }

    void showPage() {
        this.getPage();
        CardLayout cardLayout = (CardLayout)this.parent.getLayout();
        cardLayout.show(this.parent, "page " + this.pageNumber);
    }

    void prebuildPage() {
        if (this.page != null || this.buildThread != null) {
            return;
        }
        this.buildThread = new Thread(new Runnable(){

            public void run() {
                SwingPageContents.this.buildPage();
                SwingPageContents.this.buildThread = null;
            }
        });
        this.buildThread.start();
    }

    void buildPage() {
        SwingPage swingPage = new SwingPage();
        swingPage.setPreferredSize(this.pageDim);
        Iterator iterator = this.pageFields.iterator();
        while (iterator.hasNext()) {
            SwingPageField swingPageField = (SwingPageField)iterator.next();
            AbstractSwingField abstractSwingField = swingPageField.field instanceof ImageField ? new SwingImageField((ImageField)swingPageField.field) : new SwingTextField(swingPageField.field, swingPageField.value);
            abstractSwingField.getComponent().setBounds(swingPageField.rect);
            swingPage.add(abstractSwingField.getComponent());
        }
        this.parent.add((Component)swingPage, "page " + this.pageNumber);
        this.page = swingPage;
    }

    void forgetPage() {
        if (!this.isPageBuilt()) {
            return;
        }
        CardLayout cardLayout = (CardLayout)this.parent.getLayout();
        cardLayout.removeLayoutComponent(this.page);
        this.parent.remove(this.page);
        this.page = null;
    }
}

