/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Line;
import jimm.datavision.UserCancellationException;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;
import jimm.datavision.gui.ExportWin;
import jimm.datavision.gui.MenuUtils;
import jimm.datavision.gui.StatusDialog;
import jimm.datavision.layout.LayoutEngine;
import jimm.datavision.layout.swing.SwingPageContents;
import jimm.datavision.layout.swing.SwingPrintBook;
import jimm.util.I18N;

public class SwingLE
extends LayoutEngine {
    protected static final Dimension WINDOW_START_SIZE = new Dimension(600, 400);
    protected static final String PRINT_ICON = "images/Print16.gif";
    protected static final String EXPORT_ICON = "images/Export16.gif";
    protected static final String FIRST_ICON = "images/Home16.gif";
    protected static final String PREV_ICON = "images/Back16.gif";
    protected static final String NEXT_ICON = "images/Forward16.gif";
    protected static final String LAST_ICON = "images/Down16.gif";
    protected JFrame frame;
    protected Dimension pageDim;
    protected JPanel cardPanel;
    protected JScrollPane scroller;
    protected int displayPageNum;
    protected ArrayList pageContents = new ArrayList();
    protected SwingPageContents pageBeingBuilt;
    protected JLabel pageCountLabel;
    protected Action printAction;
    protected Action closeAction;
    protected Action exportAction;
    protected Action goFirstAction;
    protected Action goPrevAction;
    protected Action goNextAction;
    protected Action goLastAction;

    public void cancel() {
        super.cancel();
        this.close();
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    protected void doStart() {
        this.pageDim = new Dimension((int)this.pageWidth(), (int)this.pageHeight());
        this.frame = new JFrame(this.report.getTitle());
        this.makeActions();
        this.makeMenu(this.frame);
        this.frame.getContentPane().add((Component)this.makeToolbar(), "North");
        this.cardPanel = new JPanel();
        CardLayout cardLayout = new CardLayout(0, 0);
        this.cardPanel.setLayout(cardLayout);
        this.cardPanel.setPreferredSize(this.pageDim);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setPreferredSize(this.pageDim);
        this.cardPanel.add((Component)jPanel, "blank page");
        cardLayout.show(this.cardPanel, "blank page");
        this.scroller = new JScrollPane(this.cardPanel);
        this.scroller.setPreferredSize(WINDOW_START_SIZE);
        this.frame.getContentPane().add((Component)this.scroller, "Center");
        this.displayPageNum = 0;
        this.frame.setDefaultCloseOperation(2);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SwingLE.this.close();
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
    }

    protected void doEnd() {
        this.printAction.setEnabled(true);
        if (this.pageContents.size() > 1) {
            this.pageBeingBuilt.prebuildPage();
        }
        if (this.displayPageNum == 0) {
            this.displayPage(1);
        }
    }

    protected void makeActions() {
        URL uRL = this.getClass().getClassLoader().getResource(PRINT_ICON);
        String string = I18N.get("menu", "SwingLE.action_print");
        this.printAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingLE.this.printReport();
            }
        };
        this.printAction.putValue("ShortDescription", string);
        this.printAction.setEnabled(false);
        string = I18N.get("menu", "SwingLE.action_close");
        this.closeAction = new AbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingLE.this.close();
            }
        };
        uRL = this.getClass().getClassLoader().getResource(EXPORT_ICON);
        string = I18N.get("menu", "SwingLE.action_export");
        this.exportAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingLE.this.export();
            }
        };
        this.exportAction.putValue("ShortDescription", string);
        uRL = this.getClass().getClassLoader().getResource(FIRST_ICON);
        string = I18N.get("menu", "SwingLE.action_first_page");
        this.goFirstAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingLE.this.displayFirstPage();
            }
        };
        this.goFirstAction.putValue("ShortDescription", string);
        this.goFirstAction.setEnabled(false);
        uRL = this.getClass().getClassLoader().getResource(PREV_ICON);
        string = I18N.get("menu", "SwingLE.action_previous_page");
        this.goPrevAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingLE.this.displayPrevPage();
            }
        };
        this.goPrevAction.putValue("ShortDescription", string);
        this.goPrevAction.setEnabled(false);
        uRL = this.getClass().getClassLoader().getResource(NEXT_ICON);
        string = I18N.get("menu", "SwingLE.action_next_page");
        this.goNextAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingLE.this.displayNextPage();
            }
        };
        this.goNextAction.putValue("ShortDescription", string);
        this.goNextAction.setEnabled(false);
        uRL = this.getClass().getClassLoader().getResource(LAST_ICON);
        string = I18N.get("menu", "SwingLE.action_last_page");
        this.goLastAction = new AbstractAction(string, new ImageIcon(uRL, string)){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingLE.this.displayLastPage();
            }
        };
        this.goLastAction.putValue("ShortDescription", string);
        this.goLastAction.setEnabled(false);
    }

    protected void makeMenu(JFrame jFrame) {
        JMenuBar jMenuBar = new JMenuBar();
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = MenuUtils.readMenu("SwingLE.menu_file");
        jMenuBar.add(jMenu);
        MenuUtils.addToMenu(jMenu, this.printAction, "SwingLE.action_print");
        jMenu.addSeparator();
        MenuUtils.addToMenu(jMenu, this.closeAction, "SwingLE.action_close");
        jMenu = MenuUtils.readMenu("SwingLE.menu_view");
        jMenuBar.add(jMenu);
        MenuUtils.addToMenu(jMenu, this.goFirstAction, "SwingLE.action_first_page");
        MenuUtils.addToMenu(jMenu, this.goPrevAction, "SwingLE.action_previous_page");
        MenuUtils.addToMenu(jMenu, this.goNextAction, "SwingLE.action_next_page");
        MenuUtils.addToMenu(jMenu, this.goLastAction, "SwingLE.action_last_page");
        jMenu = MenuUtils.readMenu("SwingLE.menu_report");
        jMenuBar.add(jMenu);
        MenuUtils.addToMenu(jMenu, this.exportAction, "SwingLE.action_export");
    }

    protected JToolBar makeToolbar() {
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.add(this.printAction);
        jToolBar.addSeparator();
        jToolBar.add(this.exportAction);
        jToolBar.addSeparator();
        jToolBar.add(this.goFirstAction);
        jToolBar.add(this.goPrevAction);
        jToolBar.add(this.goNextAction);
        jToolBar.add(this.goLastAction);
        this.pageCountLabel = new JLabel(I18N.get("SwingLE.loading_first_page"));
        jToolBar.addSeparator();
        jToolBar.add(this.pageCountLabel);
        return jToolBar;
    }

    protected void doStartPage() {
        int n = this.pageContents.size() + 1;
        this.pageBeingBuilt = new SwingPageContents(this.cardPanel, n, this.pageDim);
        this.pageContents.add(this.pageBeingBuilt);
    }

    protected void doEndPage() {
        int n = this.pageContents.size();
        if (n == 1) {
            this.pageBeingBuilt.prebuildPage();
            this.pageCountLabel.setText(I18N.get("SwingLE.building_first_page"));
        }
        if (((SwingPageContents)this.pageContents.get(0)).isPageBuilt() && this.displayPageNum == 0) {
            this.displayPage(1);
        } else {
            this.updatePageCountLabel();
            this.updateNavActions();
        }
    }

    public void close() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.wantsMoreData = false;
        this.pageContents = null;
        this.pageBeingBuilt = null;
    }

    protected void export() {
        new ExportWin((Frame)this.frame, this.report);
    }

    protected void updateNavActions() {
        int n = this.pageContents.size();
        boolean bl = n > 0 && this.displayPageNum > 1;
        this.goFirstAction.setEnabled(bl);
        this.goPrevAction.setEnabled(bl);
        boolean bl2 = n > 0 && this.displayPageNum < n;
        this.goNextAction.setEnabled(bl2);
        this.goLastAction.setEnabled(bl2);
    }

    protected void updatePageCountLabel() {
        if (this.displayPageNum > 0) {
            this.pageCountLabel.setText(I18N.get("SwingLE.page") + ' ' + this.displayPageNum + ' ' + I18N.get("SwingLE.of") + ' ' + this.pageContents.size());
        }
    }

    protected void displayFirstPage() {
        if (this.pageContents.size() > 0) {
            this.displayPage(1);
        }
    }

    protected void displayNextPage() {
        if (this.pageContents.size() > this.displayPageNum) {
            this.displayPage(this.displayPageNum + 1);
        }
    }

    protected void displayPrevPage() {
        if (this.displayPageNum > 1) {
            this.displayPage(this.displayPageNum - 1);
        }
    }

    protected void displayLastPage() {
        int n = this.pageContents.size();
        if (n > 0) {
            this.displayPage(n);
        }
    }

    protected void displayPage(int n) {
        if (n == this.displayPageNum) {
            return;
        }
        SwingPageContents swingPageContents = (SwingPageContents)this.pageContents.get(n - 1);
        if (!swingPageContents.isPageBuilt()) {
            this.pageCountLabel.setText(I18N.get("SwingLE.building_page") + ' ' + n + "...");
        }
        int n2 = this.scroller.getVerticalScrollBar().getValue();
        swingPageContents.showPage();
        this.scroller.getVerticalScrollBar().setValue(n2);
        int n3 = this.pageContents.size();
        if (n3 > n) {
            swingPageContents = (SwingPageContents)this.pageContents.get(n);
            swingPageContents.prebuildPage();
        }
        if (n > 1) {
            swingPageContents = (SwingPageContents)this.pageContents.get(n - 2);
            swingPageContents.prebuildPage();
        }
        this.displayPageNum = n;
        this.updatePageCountLabel();
        this.updateNavActions();
        for (int i = 1; i < n3 - 1; ++i) {
            if (i >= this.displayPageNum - 2 && i <= this.displayPageNum) continue;
            swingPageContents = (SwingPageContents)this.pageContents.get(i);
            swingPageContents.forgetPage();
        }
    }

    protected void doOutputField(Field field) {
        if (!field.isVisible()) {
            return;
        }
        String string = field.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        jimm.datavision.field.Rectangle rectangle = field.getBounds();
        int n = this.currentSection.getArea().getArea() == 3 ? (int)(this.pageHeight() - this.currentSection.getOutputHeight() + rectangle.y) : (int)(this.pageHeightUsed + rectangle.y);
        Rectangle rectangle2 = new Rectangle((int)rectangle.x, n, (int)rectangle.width, (int)field.getOutputHeight());
        this.pageBeingBuilt.add(field, string, rectangle2);
    }

    protected void doOutputImage(ImageField imageField) {
        this.doOutputField(imageField);
    }

    protected void doOutputLine(Line line) {
    }

    public void printReport() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = this.report.getPaperFormat().getPageFormat();
        SwingPrintBook swingPrintBook = new SwingPrintBook(this.pageContents, pageFormat);
        printerJob.setPageable(swingPrintBook);
        if (printerJob.printDialog()) {
            final StatusDialog statusDialog = new StatusDialog((Frame)this.frame, I18N.get("SwingLE.print_report_title"), true, I18N.get("SwingLE.print_report_status"));
            swingPrintBook.setStatusDialog(statusDialog);
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        try {
                            printerJob.print();
                        }
                        catch (UserCancellationException userCancellationException) {
                            printerJob.cancel();
                            Object var3_2 = null;
                            if (statusDialog == null) return;
                            statusDialog.dispose();
                            return;
                        }
                        catch (Exception exception) {
                            ErrorHandler.error(exception);
                            Object var3_3 = null;
                            if (statusDialog == null) return;
                            statusDialog.dispose();
                            return;
                        }
                        Object var3_1 = null;
                        if (statusDialog == null) return;
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        if (statusDialog == null) throw throwable;
                        statusDialog.dispose();
                        throw throwable;
                    }
                    statusDialog.dispose();
                }
            }).start();
        }
    }
}

