/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jimm.datavision.ErrorHandler;
import jimm.datavision.Line;
import jimm.datavision.PaperFormat;
import jimm.datavision.Point;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.field.ImageField;
import jimm.datavision.layout.LayoutEngine;
import jimm.datavision.layout.LineDrawer;
import jimm.util.StringUtils;

public class PDFLE
extends LayoutEngine
implements LineDrawer {
    protected OutputStream outStream;
    protected Document doc;
    protected PdfContentByte content;
    protected HashMap baseFonts;
    protected double prevThickness;

    public PDFLE(OutputStream outputStream) {
        super(null);
        this.outStream = outputStream;
    }

    protected void doStart() {
        this.baseFonts = new HashMap();
        PaperFormat paperFormat = this.report.getPaperFormat();
        this.doc = new Document(new Rectangle(0.0f, 0.0f, (float)((int)paperFormat.getWidth()), (float)((int)paperFormat.getHeight())), (float)paperFormat.getImageableX(), (float)(paperFormat.getWidth() + paperFormat.getImageableX()), (float)paperFormat.getImageableY(), (float)(paperFormat.getHeight() + paperFormat.getImageableY()));
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)this.doc, (OutputStream)this.outStream);
            this.baseFonts.put("Helvetica", BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false));
        }
        catch (DocumentException documentException) {
            ErrorHandler.error(documentException);
            this.wantsMoreData = false;
            return;
        }
        catch (IOException iOException) {
            ErrorHandler.error(iOException);
            this.wantsMoreData = false;
            return;
        }
        String string = null;
        string = this.report.getTitle();
        if (string != null) {
            this.doc.addTitle(string);
        }
        if ((string = this.report.getAuthor()) != null) {
            this.doc.addAuthor(string);
        }
        this.doc.addCreator("DataVision version 1.0.0 <http://datavision.sourceforge.net>");
        this.doc.addCreationDate();
        this.doc.open();
        this.content = pdfWriter.getDirectContent();
    }

    protected void doEnd() {
        this.doc.close();
    }

    protected void doStartPage() {
        try {
            this.prevThickness = 0.0;
            this.doc.newPage();
        }
        catch (DocumentException documentException) {
            ErrorHandler.error(documentException);
            this.wantsMoreData = false;
        }
    }

    protected void doOutputField(Field field) {
        int n;
        String string = field.toString();
        if (string == null || string.length() == 0) {
            this.makeBorders(field);
            return;
        }
        Format format = field.getFormat();
        BaseFont baseFont = this.getFontForFormat(format);
        float f = (float)format.getSize();
        Point point = this.bottomLeftOfField(field, format.getSize(), baseFont);
        switch (format.getAlign()) {
            case 1: {
                n = 1;
                point.x += field.getBounds().width / 2.0;
                break;
            }
            case 2: {
                n = 2;
                point.x += field.getBounds().width;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.content.beginText();
        this.content.setFontAndSize(baseFont, f);
        this.content.setColorFill(format.getColor());
        List list = StringUtils.splitIntoLines(string);
        double d = field.getOutputHeight() / (double)list.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.content.showTextAligned(n, string2, (float)point.x, (float)point.y, 0.0f);
            point.y -= d;
        }
        this.content.endText();
        this.makeBorders(field);
    }

    protected Point bottomLeftOfField(Field field, double d, BaseFont baseFont) {
        jimm.datavision.field.Rectangle rectangle = field.getBounds();
        Point point = new Point(rectangle.x, rectangle.y);
        this.translateToPDFCoords(point);
        point.y -= (double)baseFont.getFontDescriptor(3, (float)d) + rectangle.height;
        return point;
    }

    protected void translateToPDFCoords(Point point) {
        point.y = this.currentSection.getArea().getArea() != 3 ? this.pageHeight() - this.pageHeightUsed - point.y : this.currentSection.getOutputHeight() - point.y;
    }

    protected BaseFont getFontForFormat(Format format) {
        String string = this.baseFontName(format.getFont());
        BaseFont baseFont = (BaseFont)this.baseFonts.get(string);
        if (baseFont == null) {
            try {
                baseFont = BaseFont.createFont((String)string, (String)"Cp1252", (boolean)false);
                this.baseFonts.put(string, baseFont);
            }
            catch (Exception exception) {
                ErrorHandler.error(exception);
                baseFont = (BaseFont)this.baseFonts.get("Helvetica");
            }
        }
        return baseFont;
    }

    protected String baseFontName(Font font) {
        String string = font.getFamily().toLowerCase();
        if (string.startsWith("courier") || string.startsWith("monospace")) {
            return "Courier" + this.fontAttributes(font, "Bold", "Oblique");
        }
        if (string.startsWith("helvetica") || string.startsWith("sansserif")) {
            return "Helvetica" + this.fontAttributes(font, "Bold", "Oblique");
        }
        if (string.startsWith("symbol")) {
            return "Symbol";
        }
        if (string.startsWith("zapfdingbats")) {
            return "ZapfDingbats";
        }
        String string2 = this.fontAttributes(font, "Bold", "Italic");
        return "Times" + (string2.length() > 0 ? string2 : "-Roman");
    }

    protected String fontAttributes(Font font, String string, String string2) {
        if (font.isBold() && font.isItalic()) {
            return "-" + string + string2;
        }
        if (font.isBold()) {
            return "-" + string;
        }
        if (font.isItalic()) {
            return "-" + string2;
        }
        return "";
    }

    protected void doOutputImage(ImageField imageField) {
        try {
            Image image = Image.getInstance((URL)imageField.getImageURL());
            jimm.datavision.field.Rectangle rectangle = imageField.getBounds();
            Point point = new Point(rectangle.x, rectangle.y);
            this.translateToPDFCoords(point);
            point.y -= imageField.getOutputHeight();
            image.setAbsolutePosition((float)point.x, (float)point.y);
            this.content.addImage(image);
        }
        catch (Exception exception) {
            this.wantsMoreData = false;
            ErrorHandler.error(exception);
        }
    }

    protected void doOutputLine(Line line) {
        this.drawLine(line, Boolean.TRUE);
    }

    protected void makeBorders(Field field) {
        field.getBorderOrDefault().eachLine(this, Boolean.FALSE);
        this.content.stroke();
    }

    public void drawLine(Line line, Object object) {
        if (line.getThickness() != this.prevThickness) {
            this.prevThickness = line.getThickness();
            this.content.setLineWidth((float)this.prevThickness);
        }
        Point point = new Point(line.getPoint(0));
        Point point2 = new Point(line.getPoint(1));
        this.translateToPDFCoords(point);
        this.translateToPDFCoords(point2);
        this.content.moveTo((float)point.x, (float)point.y);
        this.content.lineTo((float)point2.x, (float)point2.y);
        if (object != Boolean.FALSE) {
            this.content.stroke();
        }
    }
}

