/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout;

import jimm.datavision.Line;
import jimm.datavision.Section;
import jimm.datavision.field.AggregateField;
import jimm.datavision.field.ColumnField;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;
import jimm.datavision.field.SpecialField;
import jimm.datavision.layout.SortedLayoutEngine;
import jimm.util.XMLWriter;

public class XMLLE
extends SortedLayoutEngine {
    protected XMLWriter iout;
    protected String encoding;

    public XMLLE(XMLWriter xMLWriter) {
        this(xMLWriter, "UTF-8");
    }

    public XMLLE(XMLWriter xMLWriter, String string) {
        super(xMLWriter);
        this.iout = xMLWriter;
        this.encoding = string == null ? "UTF-8" : string;
    }

    protected void doStart() {
        this.iout.xmlDecl(this.encoding);
        this.iout.comment("Generated by DataVision version 1.0.0");
        this.iout.comment("http://datavision.sourceforge.net");
        this.iout.startElement("report");
    }

    protected void doEnd() {
        this.iout.endElement();
        this.iout.flush();
    }

    protected void doStartPage() {
        this.iout.comment("============== Page " + this.pageNumber() + " ==============");
        this.iout.startElement("newpage");
        this.iout.attr("number", this.pageNumber());
        this.iout.endElement();
    }

    protected void doOutputSection(Section section) {
        this.iout.startElement("section");
        this.iout.attr("type", this.currentSectionTypeAsString());
        super.doOutputSection(section);
        this.iout.endElement();
    }

    protected void doOutputField(Field field) {
        AggregateField aggregateField;
        this.iout.startElement("field");
        this.iout.attr("id", field.getId());
        this.iout.attr("type", field.typeString());
        if (field instanceof SpecialField) {
            this.iout.attr("value", field.getValue());
        } else if (field instanceof ColumnField) {
            this.iout.attr(" column", ((ColumnField)field).getColumn().fullName());
        } else if (field instanceof AggregateField && (aggregateField = (AggregateField)field).getGroup() != null) {
            this.iout.attr("group", aggregateField.getGroup().getSelectable().getDisplayName());
        }
        this.iout.cdata(field.toString());
        this.iout.endElement();
    }

    protected void doOutputImage(ImageField imageField) {
        this.doOutputField(imageField);
    }

    protected void doOutputLine(Line line) {
        line.writeXML(this.iout);
    }
}

