/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import jimm.datavision.Element;
import jimm.datavision.Line;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;
import jimm.datavision.layout.LayoutEngine;

public abstract class SortedLayoutEngine
extends LayoutEngine {
    protected HashMap sectionFields = new HashMap();
    protected Comparator comp = new Comparator(){

        public int compare(Object object, Object object2) {
            double d = ((Field)object).getBounds().y;
            double d2 = ((Field)object2).getBounds().y;
            if (d == d2) {
                double d3 = ((Field)object).getBounds().x;
                double d4 = ((Field)object2).getBounds().x;
                return d3 < d4 ? -1 : (d3 > d4 ? 1 : 0);
            }
            return d < d2 ? -1 : (d > d2 ? 1 : 0);
        }
    };

    public SortedLayoutEngine() {
        this(null);
    }

    public SortedLayoutEngine(PrintWriter printWriter) {
        super(printWriter);
    }

    protected void doOutputSection(Section section) {
        Element element;
        Object[] objectArray = (Object[])this.sectionFields.get(section);
        if (objectArray == null) {
            objectArray = this.buildSectionFields(section);
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                element = (Field)objectArray[i];
                if (!element.isVisible()) continue;
                if (element instanceof ImageField) {
                    this.outputImage((ImageField)element);
                    continue;
                }
                this.outputField((Field)element);
            }
        }
        Iterator iterator = section.lines();
        while (iterator.hasNext()) {
            element = (Line)iterator.next();
            if (!element.isVisible()) continue;
            this.outputLine((Line)element);
        }
    }

    protected Object[] buildSectionFields(Section section) {
        int n = section.numFields();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = section.fieldsSortedBy(this.comp);
        this.sectionFields.put(section, objectArray);
        return objectArray;
    }
}

