/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import jimm.datavision.Element;
import jimm.datavision.Group;
import jimm.datavision.Line;
import jimm.datavision.Report;
import jimm.datavision.Section;
import jimm.datavision.SectionArea;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;

public abstract class LayoutEngine {
    public static final int POINTS_PER_INCH = 72;
    protected static final int SECT_REPORT_HEADER = 0;
    protected static final int SECT_REPORT_FOOTER = 1;
    protected static final int SECT_PAGE_HEADER = 2;
    protected static final int SECT_PAGE_FOOTER = 3;
    protected static final int SECT_GROUP_HEADER = 4;
    protected static final int SECT_GROUP_FOOTER = 5;
    protected static final int SECT_DETAIL = 6;
    protected Report report = null;
    protected int pageNumber;
    protected PrintWriter out;
    protected boolean newPage;
    protected double pageHeight;
    protected double pageWidth;
    protected double pageHeightUsed;
    protected Section currentSection;
    protected boolean wantsMoreData;
    protected int previousSectionArea;

    public LayoutEngine() {
        this(null);
    }

    public LayoutEngine(PrintWriter printWriter) {
        this.out = printWriter;
        this.wantsMoreData = true;
        this.previousSectionArea = -1;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public double pageWidth() {
        return this.pageWidth;
    }

    public double pageHeight() {
        return this.pageHeight;
    }

    public boolean wantsMoreData() {
        return this.wantsMoreData;
    }

    public void cancel() {
        this.closeOutput();
    }

    public void start() {
        this.newPage = true;
        this.pageHeightUsed = 0.0;
        this.pageNumber = 0;
        this.pageHeight = this.report.getPaperFormat().getHeight();
        this.pageWidth = this.report.getPaperFormat().getWidth();
        if (this.wantsMoreData) {
            this.doStart();
            this.startPage();
        }
    }

    protected void doStart() {
    }

    public void end() {
        if (this.wantsMoreData) {
            Iterator iterator = this.report.footers().iterator();
            while (iterator.hasNext()) {
                this.outputSection((Section)iterator.next(), 1);
            }
            this.endPage(true);
            this.doEnd();
        }
        this.closeOutput();
    }

    protected void doEnd() {
    }

    protected void closeOutput() {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    public void groupHeaders(boolean bl) {
        Iterator iterator;
        Group group;
        if (!this.wantsMoreData) {
            return;
        }
        boolean bl2 = false;
        Iterator iterator2 = this.report.groups();
        while (iterator2.hasNext()) {
            group = (Group)iterator2.next();
            if (!bl2 && !group.isNewValue()) continue;
            iterator = group.headers().iterator();
            while (iterator.hasNext()) {
                ((Section)iterator.next()).evaluateFormulas();
            }
            bl2 = true;
        }
        this.checkRemainingPageLength(bl, true);
        bl2 = false;
        iterator2 = this.report.groups();
        while (iterator2.hasNext()) {
            group = (Group)iterator2.next();
            if (!bl2 && !group.isNewValue()) continue;
            iterator = group.headers().iterator();
            while (iterator.hasNext()) {
                this.outputSection((Section)iterator.next(), 4);
            }
            bl2 = true;
        }
    }

    public void detail(boolean bl) {
        if (!this.wantsMoreData) {
            return;
        }
        this.checkRemainingPageLength(bl, true);
        Iterator iterator = this.report.details().iterator();
        while (iterator.hasNext()) {
            this.outputSection((Section)iterator.next(), 6);
        }
    }

    public void groupFooters(boolean bl) {
        Group group;
        if (!this.wantsMoreData) {
            return;
        }
        this.checkRemainingPageLength(bl, false);
        boolean bl2 = false;
        ArrayList<Group> arrayList = new ArrayList<Group>();
        Iterator iterator = this.report.groups();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            if (!bl2 && !group.isNewValue() && !bl) continue;
            if (bl2) {
                group.forceFooterOutput();
            }
            arrayList.add(group);
            bl2 = true;
        }
        Collections.reverse(arrayList);
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            Iterator iterator2 = group.footers().iterator();
            while (iterator2.hasNext()) {
                this.outputSection((Section)iterator2.next(), 5);
            }
        }
    }

    protected void checkRemainingPageLength(boolean bl, boolean bl2) {
        double d = bl2 ? this.calcDetailHeight() : 0.0;
        double d2 = this.calcPageFooterHeight();
        if (bl) {
            d2 += this.calcReportFooterHeight();
        }
        if (this.pageHeightUsed + d2 + d > this.pageHeight()) {
            this.endPage(bl);
        }
        if (this.newPage) {
            this.startPage();
        }
    }

    public int pageNumber() {
        return this.pageNumber;
    }

    protected void startPage() {
        Iterator iterator;
        if (!this.wantsMoreData) {
            return;
        }
        ++this.pageNumber;
        this.pageHeightUsed = 0.0;
        this.newPage = false;
        this.doStartPage();
        if (this.pageNumber == 1) {
            iterator = this.report.headers().iterator();
            while (iterator.hasNext()) {
                this.outputSection((Section)iterator.next(), 0);
            }
        }
        iterator = this.report.pageHeaders().iterator();
        while (iterator.hasNext()) {
            this.outputSection((Section)iterator.next(), 2);
        }
    }

    protected void doStartPage() {
    }

    protected void endPage(boolean bl) {
        if (!this.wantsMoreData) {
            return;
        }
        Iterator iterator = this.report.pageFooters().iterator();
        while (iterator.hasNext()) {
            this.outputSection((Section)iterator.next(), 3);
        }
        this.newPage = true;
        this.doEndPage();
    }

    protected void doEndPage() {
    }

    protected void outputSection(Section section, int n) {
        if (!this.wantsMoreData) {
            return;
        }
        if (section.isVisibleForCurrentRow()) {
            if (section.hasPageBreak() && this.previousSectionArea != 2) {
                this.endPage(false);
                this.startPage();
            }
            this.currentSection = section;
            this.report.evaluateFormulasIn(this.currentSection);
            this.doOutputSection(this.currentSection);
            this.pageHeightUsed += section.getOutputHeight();
            this.previousSectionArea = n;
        } else {
            this.report.evaluateFormulasIn(section);
        }
    }

    protected void doOutputSection(Section section) {
        Element element;
        Iterator iterator = section.fields();
        while (iterator.hasNext()) {
            element = (Field)iterator.next();
            if (!element.isVisible()) continue;
            if (element instanceof ImageField) {
                this.outputImage((ImageField)element);
                continue;
            }
            this.outputField((Field)element);
        }
        iterator = section.lines();
        while (iterator.hasNext()) {
            element = (Line)iterator.next();
            if (!element.isVisible()) continue;
            this.outputLine((Line)element);
        }
    }

    protected void outputField(Field field) {
        if (this.wantsMoreData) {
            this.doOutputField(field);
        }
    }

    protected abstract void doOutputField(Field var1);

    protected void outputImage(ImageField imageField) {
        if (this.wantsMoreData) {
            this.doOutputImage(imageField);
        }
    }

    protected abstract void doOutputImage(ImageField var1);

    protected void outputLine(Line line) {
        if (this.wantsMoreData) {
            this.doOutputLine(line);
        }
    }

    protected abstract void doOutputLine(Line var1);

    protected String currentSectionTypeAsString() {
        switch (this.currentSection.getArea().getArea()) {
            case 0: {
                return "report header";
            }
            case 1: {
                return "report footer";
            }
            case 2: {
                return "page header";
            }
            case 3: {
                return "page footer";
            }
            case 5: {
                return "group header";
            }
            case 6: {
                return "group footer";
            }
            case 4: {
                return "detail";
            }
        }
        return "unknown";
    }

    protected double calcSectionHeights(SectionArea sectionArea) {
        double d = 0.0;
        Iterator iterator = sectionArea.iterator();
        while (iterator.hasNext()) {
            Section section = (Section)iterator.next();
            if (!section.isVisibleForCurrentRow()) continue;
            d += section.getOutputHeight();
        }
        return d;
    }

    protected double calcDetailHeight() {
        return this.calcSectionHeights(this.report.details());
    }

    protected double calcPageFooterHeight() {
        return this.calcSectionHeights(this.report.pageFooters());
    }

    protected double calcReportFooterHeight() {
        return this.calcSectionHeights(this.report.footers());
    }
}

