/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout;

import java.io.PrintWriter;
import jimm.datavision.Line;
import jimm.datavision.Point;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.field.ImageField;
import jimm.datavision.field.Rectangle;
import jimm.datavision.layout.LayoutEngine;
import jimm.datavision.layout.LineDrawer;

public class LaTeXLE
extends LayoutEngine
implements LineDrawer {
    protected double linethickness = 0.0;

    public LaTeXLE(PrintWriter printWriter) {
        super(printWriter);
    }

    protected void doStart() {
        String string = this.report.getPaperFormat().getLaTeXPaperSizeString();
        this.out.println("\\documentclass[11pt" + (string == null ? "" : "," + string) + "]{article}\n" + "\n" + "\\oddsidemargin -1in\n" + "\\evensidemargin -1in\n" + "\\textwidth " + this.pageWidth() + "pt\n" + "\\headheight -0.5pt\n" + "\\headsep 0pt\n" + "\\topmargin 0.0in\n" + "\\textheight " + this.pageHeight() + "pt\n" + "\n" + "\\begin{document}\n" + "\\pagestyle{empty}\n" + "\\setlength{\\unitlength}{1pt}\n" + "% Generated by DataVision version " + "1.0.0" + "\n" + "% " + "http://datavision.sourceforge.net");
    }

    protected void doEnd() {
        this.out.println("\\end{document}");
    }

    protected void doStartPage() {
        if (this.pageNumber > 1) {
            this.out.println("\\newpage");
        }
        this.out.println("% ======== Page " + this.pageNumber + " ========");
        this.out.println("\\begin{picture}(" + this.pageWidth() + "," + this.pageHeight() + ")");
    }

    protected void doEndPage() {
        this.out.println("\\end{picture}");
    }

    protected void doOutputField(Field field) {
        String string = field.toString();
        if (string == null || string.length() == 0) {
            this.makeBorders(field);
            this.out.println();
            return;
        }
        Format format = field.getFormat();
        Rectangle rectangle = field.getBounds();
        this.putField(field);
        String[] stringArray = this.selectFontSize(format);
        if (stringArray != null) {
            this.out.print(stringArray[0]);
        }
        String string2 = "";
        switch (format.getAlign()) {
            case 1: {
                string2 = "\\begin{center}";
                break;
            }
            case 2: {
                string2 = "\\raggedleft ";
            }
        }
        this.out.print("\\begin{minipage}[t]{" + rectangle.width + "pt}" + string2);
        if (format.isBold()) {
            this.out.print("\\textbf{");
        }
        if (format.isItalic()) {
            this.out.print("\\textit{");
        }
        if (format.isUnderline()) {
            this.out.print("\\underline{");
        }
        this.out.print(this.makeSafe(string));
        if (format.isUnderline()) {
            this.out.print("}");
        }
        if (format.isItalic()) {
            this.out.print("}");
        }
        if (format.isBold()) {
            this.out.print("}");
        }
        if (format.getAlign() == 1) {
            this.out.print("\\end{center}");
        }
        this.out.print("\\end{minipage}");
        if (stringArray != null) {
            this.out.print(stringArray[1]);
        }
        this.out.print("}");
        this.makeBorders(field);
        this.out.println();
    }

    protected void doOutputImage(ImageField imageField) {
    }

    protected void doOutputLine(Line line) {
        this.drawLine(line, null);
    }

    protected String[] selectFontSize(Format format) {
        if (format == null || format.getSize() == 0.0) {
            return null;
        }
        String[] stringArray = new String[]{"{\\fontsize{" + format.getSize() + "pt}{" + format.getSize() * 1.2 + "pt}", "}"};
        return stringArray;
    }

    protected void makeBorders(Field field) {
        field.getBorderOrDefault().eachLine(this, null);
    }

    public void drawLine(Line line, Object object) {
        double d;
        double d2;
        Point point = line.getPoint(0);
        Point point2 = line.getPoint(1);
        double d3 = point2.x - point.x;
        double d4 = point2.y - point.y;
        if (d3 == 0.0 && d4 == 0.0) {
            return;
        }
        if (d4 == 0.0) {
            d2 = point2.x < point.x ? -1.0 : (point2.x > point.x ? 1.0 : 0.0);
            d = 0.0;
        } else if (d3 == 0.0) {
            d2 = 0.0;
            d = point2.y < point.y ? 1.0 : (point2.y > point.y ? -1.0 : 0.0);
        } else {
            d2 = d3;
            d = d4;
            double[] dArray = this.pickNearestSlope(d2 / d);
            if (dArray == null) {
                d2 = 1.0;
                d = 0.0;
            } else {
                d2 = dArray[0];
                d = dArray[1];
            }
        }
        this.setLineThickness(line.getThickness());
        this.putLine(line, d2, d);
    }

    protected double[] pickNearestSlope(double d) {
        boolean bl = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = -6; i <= 6; ++i) {
            for (int j = -6; j <= 6; ++j) {
                if (bl && !(d2 > d - (double)Math.abs(i / j))) continue;
                d2 = Math.abs(d - (double)(i / j));
                d3 = i;
                d4 = j;
                bl = true;
            }
        }
        if (!bl) {
            return null;
        }
        double[] dArray = new double[]{d3, d4};
        return dArray;
    }

    protected void setLineThickness(double d) {
        if (this.linethickness != d) {
            this.linethickness = d;
            this.out.print("\\linethickness{" + this.linethickness + "pt}");
        }
    }

    protected void putField(Field field) {
        Rectangle rectangle = field.getBounds();
        double d = this.currentSection.getArea().getArea() == 3 ? this.currentSection.getOutputHeight() - rectangle.y : this.pageHeight() - (this.pageHeightUsed + rectangle.y);
        this.out.print("\\put(" + rectangle.x + "," + (d -= field.getOutputHeight()) + "){");
    }

    protected void putLine(Line line, double d, double d2) {
        Point point = line.getPoint(0);
        double d3 = this.currentSection.getArea().getArea() == 3 ? point.y : this.pageHeight() - (this.pageHeightUsed + point.y);
        this.out.println("\\put(" + point.x + "," + d3 + "){\\line(" + (int)d + "," + (int)d2 + "){" + line.length() + "}}");
    }

    protected String makeSafe(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("$\\backslash$");
                    continue block5;
                }
                case '~': {
                    stringBuffer.append("\\textasciitilde");
                    continue block5;
                }
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '^': 
                case '_': 
                case '{': 
                case '}': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

