/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout;

import java.awt.Color;
import java.io.PrintWriter;
import javax.swing.ImageIcon;
import jimm.datavision.Line;
import jimm.datavision.Section;
import jimm.datavision.field.Border;
import jimm.datavision.field.Field;
import jimm.datavision.field.Format;
import jimm.datavision.field.ImageField;
import jimm.datavision.field.Rectangle;
import jimm.datavision.layout.SortedLayoutEngine;
import jimm.util.StringUtils;

public class HTMLLE
extends SortedLayoutEngine {
    protected int rowX;

    public HTMLLE(PrintWriter printWriter) {
        super(printWriter);
    }

    protected void doStart() {
        this.out.println("<html>");
        this.out.println("<head>");
        this.out.println("<!-- Generated by DataVision version 1.0.0 -->");
        this.out.println("<!-- http://datavision.sourceforge.net -->");
        String string = this.report.getTitle();
        if (string != null && string.length() > 0) {
            this.out.println("<title>" + this.report.getTitle() + "</title>");
        }
        this.out.println("</head>");
        this.out.println("<body bgcolor=\"white\">");
    }

    protected void doEnd() {
        this.out.println("</body>");
        this.out.println("</html>");
        this.out.flush();
    }

    protected void doOutputSection(Section section) {
        this.out.println("<table width=\"" + this.pageWidth() + "pt\">");
        this.out.println("<tr height=\"" + section.getOutputHeight() + "pt\">");
        this.rowX = 0;
        super.doOutputSection(section);
        if ((double)this.rowX < this.pageWidth()) {
            this.out.println("<td width=\"" + (this.pageWidth() - (double)this.rowX) + "pt\">&nbsp;</td>");
        }
        this.out.println("</tr>");
        this.out.println("</table>");
    }

    protected void doOutputField(Field field) {
        String string;
        Format format = this.outputCellStart(field);
        this.out.print("<font style=\"");
        if (format.getFontFamilyName() != null) {
            this.out.print("font-family: " + format.getFontFamilyName() + "; ");
        }
        this.out.print("font-size: " + format.getSize() + "pt; ");
        this.outputColor(format.getColor());
        Border border = field.getBorderOrDefault();
        String string2 = "black";
        if (border.getColor() != null) {
            string2 = "#" + Integer.toHexString(border.getColor().getRed()) + Integer.toHexString(border.getColor().getGreen()) + Integer.toHexString(border.getColor().getBlue());
        }
        if (border.getTop() != null) {
            this.out.print("border-top: solid " + string2 + " " + border.getTop().getThickness() + "pt; ");
        }
        if (border.getLeft() != null) {
            this.out.print("border-left: solid " + string2 + " " + border.getLeft().getThickness() + "pt; ");
        }
        if (border.getBottom() != null) {
            this.out.print("border-bottom: solid " + string2 + " " + border.getBottom().getThickness() + "pt; ");
        }
        if (border.getRight() != null) {
            this.out.print("border-right: solid " + string2 + " " + border.getRight().getThickness() + "pt; ");
        }
        this.out.print("\">");
        if (format.isBold()) {
            this.out.print("<b>");
        }
        if (format.isItalic()) {
            this.out.print("<i>");
        }
        if (format.isUnderline()) {
            this.out.print("<u>");
        }
        if ((string = field.toString()) == null || string.length() == 0) {
            string = "&nbsp;";
        }
        if ("&nbsp;".equals(string)) {
            this.out.print(string);
        } else {
            this.out.print(StringUtils.newlinesToXHTMLBreaks(StringUtils.escapeHTML(string)));
        }
        if (format.isUnderline()) {
            this.out.print("</u>");
        }
        if (format.isItalic()) {
            this.out.print("</i>");
        }
        if (format.isBold()) {
            this.out.print("</b>");
        }
        this.out.print("</font>");
        this.outputCellEnd();
    }

    protected void doOutputImage(ImageField imageField) {
        String string;
        int n;
        if (imageField == null || imageField.getImageURL() == null) {
            return;
        }
        this.outputCellStart(imageField);
        ImageIcon imageIcon = imageField.getImageIcon();
        String string2 = imageField.getImageURL().toString();
        if (string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        if ((n = (string = string2).lastIndexOf("/")) != -1) {
            string = string.substring(n + 1);
        }
        this.out.print("<img src=\"" + StringUtils.escapeHTML(string2) + "\" alt=\"" + StringUtils.escapeHTML(string) + "\" width=\"" + imageIcon.getIconWidth() + "\" height=\"" + imageIcon.getIconHeight() + "\">");
        this.outputCellEnd();
    }

    protected Format outputCellStart(Field field) {
        Format format = field.getFormat();
        Rectangle rectangle = field.getBounds();
        if (rectangle.x > (double)this.rowX) {
            this.out.println("<td width=\"" + (rectangle.x - (double)this.rowX) + "pt\">&nbsp;</td>");
        }
        this.rowX = (int)(rectangle.x + rectangle.width);
        String string = null;
        switch (format.getAlign()) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "center";
                break;
            }
            case 2: {
                string = "right";
            }
        }
        this.out.print("<td align=\"" + string + "\" width=\"" + (int)rectangle.width + "pt\" height=\"" + (int)field.getOutputHeight() + "pt\"");
        if (!format.isWrap()) {
            this.out.print(" nowrap");
        }
        this.out.print(">");
        return format;
    }

    protected void outputCellEnd() {
        this.out.println("</td>");
    }

    protected void outputColor(Color color) {
        if (color.equals(Color.black)) {
            return;
        }
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        this.out.print(" color: #");
        for (int i = 0; i < 3; ++i) {
            if (nArray[i] < 16) {
                this.out.print('0');
            }
            this.out.print(Integer.toHexString(nArray[i]));
        }
    }

    protected void doOutputLine(Line line) {
    }
}

