/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import jimm.datavision.Line;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;
import jimm.datavision.field.Rectangle;
import jimm.datavision.layout.DocBookCol;
import jimm.datavision.layout.SortedLayoutEngine;

public class DocBookLE
extends SortedLayoutEngine {
    protected HashMap sectionCols;

    public DocBookLE(PrintWriter printWriter) {
        super(printWriter);
    }

    protected void doStart() {
        this.sectionCols = new HashMap();
        this.out.println("<!DOCTYPE informaltable PUBLIC \"-//OASIS//DTD DocBook V3.1//EN\">");
        this.out.println("<!-- Generated by DataVision version 1.0.0 -->");
        this.out.println("<!-- http://datavision.sourceforge.net -->");
        this.out.println("<informaltable colsep=\"1\" rowsep=\"1\">");
    }

    protected void doEnd() {
        this.out.println("</informaltable>");
    }

    protected void doStartPage() {
        if (this.pageNumber > 1) {
            this.out.println("<beginpage pagenum=\"" + this.pageNumber + "\">");
        }
        this.out.println("<!-- ======== Page " + this.pageNumber + " ======== -->");
    }

    protected void doOutputSection(Section section) {
        DocBookCol docBookCol;
        Collection collection = this.calcSectionCols(section);
        if (collection.isEmpty()) {
            return;
        }
        this.out.println("<tgroup cols=" + collection.size() + ">");
        int n = 1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            docBookCol = (DocBookCol)iterator.next();
            this.out.println("<colspec colname=c" + n + " colwidth=\"" + docBookCol.width + "\">");
            ++n;
        }
        this.out.println("<tbody>");
        this.out.println("<row>");
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            docBookCol = (DocBookCol)iterator.next();
            docBookCol.output(this.out);
            ++n;
        }
        this.out.println("</row>");
        this.out.println("</tbody>");
        this.out.println("</tgroup>");
    }

    protected void doOutputField(Field field) {
    }

    protected void doOutputImage(ImageField imageField) {
    }

    protected void doOutputLine(Line line) {
    }

    protected Collection calcSectionCols(Section section) {
        ArrayList<DocBookCol> arrayList = null;
        arrayList = (ArrayList<DocBookCol>)this.sectionCols.get(section);
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList<DocBookCol>();
        double d = 0.0;
        Iterator iterator = section.fields();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            Rectangle rectangle = field.getBounds();
            if (rectangle.x > d) {
                arrayList.add(new DocBookCol(null, d, rectangle.x - d));
                d = rectangle.x;
            }
            arrayList.add(new DocBookCol(field, rectangle.x, rectangle.width));
            d += rectangle.width;
        }
        this.sectionCols.put(section, arrayList);
        return arrayList;
    }
}

