/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.layout;

import java.io.PrintWriter;
import jimm.datavision.Line;
import jimm.datavision.Section;
import jimm.datavision.field.Field;
import jimm.datavision.field.ImageField;
import jimm.datavision.layout.SortedLayoutEngine;

public class CharSepLE
extends SortedLayoutEngine {
    protected char sepChar;
    protected boolean first;

    public CharSepLE(PrintWriter printWriter, char c) {
        super(printWriter);
        this.sepChar = c;
    }

    protected void doOutputSection(Section section) {
        this.first = true;
        super.doOutputSection(section);
        this.out.println();
    }

    protected void doOutputField(Field field) {
        String string = field.toString();
        if (string == null) {
            string = "";
        }
        if (this.first) {
            this.first = false;
        } else {
            this.out.print(this.sepChar);
        }
        this.out.print(this.asSafeSepString(string));
    }

    protected void doOutputImage(ImageField imageField) {
        this.doOutputField(imageField);
    }

    protected void doOutputLine(Line line) {
    }

    protected String asSafeSepString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\"\"");
                    bl = true;
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append(c);
                    bl = true;
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                    if (c != this.sepChar) continue block4;
                    bl = true;
                }
            }
        }
        if (bl) {
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }
}

