/*
 * Decompiled with CFR 0.152.
 */
package jimm.datavision.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jimm.datavision.Report;
import jimm.datavision.gui.Designer;
import jimm.datavision.gui.EditWin;
import jimm.datavision.gui.cmd.Command;
import jimm.datavision.gui.cmd.TableJoinCommand;
import jimm.datavision.source.Column;
import jimm.datavision.source.DataSource;
import jimm.datavision.source.Join;
import jimm.datavision.source.Query;
import jimm.util.I18N;

public class VisTableWin
extends EditWin
implements ActionListener {
    protected Report report;
    protected Query query;
    protected ArrayList joinFieldsList;
    protected JPanel joinsPanel;
    protected Box delCheckBoxPanel;
    protected Box fromPanel;
    protected Box relationPanel;
    protected Box toPanel;
    protected JButton deleteButton;

    public VisTableWin(Designer designer, Report report) {
        this(designer, report, report.getDataSource().getQuery());
    }

    public VisTableWin(Designer designer, Report report, Query query) {
        super(designer, I18N.get("VisTableWin.title"), "TableJoinCommand.name");
        this.report = report;
        this.query = query;
        this.buildWindow();
        this.pack();
        this.setVisible(true);
    }

    protected void buildWindow() {
        this.buildJoinsPanel();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(I18N.get("VisTableWin.add"));
        jButton.addActionListener(this);
        jPanel.add(jButton);
        this.deleteButton = new JButton(I18N.get("VisTableWin.delete_selected"));
        this.deleteButton.addActionListener(this);
        jPanel.add(this.deleteButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.joinsPanel, "Center");
        jPanel2.add((Component)jPanel, "South");
        JPanel jPanel3 = this.closeButtonPanel();
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
    }

    protected void buildJoinsPanel() {
        this.joinsPanel = new JPanel();
        this.joinsPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        Box box = Box.createHorizontalBox();
        this.joinsPanel.add(box);
        this.delCheckBoxPanel = Box.createVerticalBox();
        this.fromPanel = Box.createVerticalBox();
        this.relationPanel = Box.createVerticalBox();
        this.toPanel = Box.createVerticalBox();
        this.fillJoinsPanel();
        box.add(this.delCheckBoxPanel);
        box.add(this.fromPanel);
        box.add(this.relationPanel);
        box.add(this.toPanel);
    }

    protected void fillJoinsPanel() {
        Object object;
        this.joinFieldsList = new ArrayList();
        Iterator iterator = this.query.joins();
        while (iterator.hasNext()) {
            object = (Join)iterator.next();
            this.joinFieldsList.add(new JoinFields((Join)object, this.report.getDataSource()));
        }
        iterator = this.joinFieldsList.iterator();
        while (iterator.hasNext()) {
            object = (JoinFields)iterator.next();
            this.delCheckBoxPanel.add(((JoinFields)object).del);
            this.fromPanel.add(((JoinFields)object).from);
            this.relationPanel.add(((JoinFields)object).relation);
            this.toPanel.add(((JoinFields)object).to);
        }
    }

    protected void emptyJoinsPanel() {
        this.delCheckBoxPanel.removeAll();
        this.fromPanel.removeAll();
        this.relationPanel.removeAll();
        this.toPanel.removeAll();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(I18N.get("VisTableWin.add"))) {
            this.addNewJoin();
        } else if (string.equals(I18N.get("VisTableWin.delete_selected"))) {
            this.deleteSelectedJoins();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void addNewJoin() {
        JoinFields joinFields = new JoinFields(null, this.report.getDataSource());
        this.joinFieldsList.add(joinFields);
        this.delCheckBoxPanel.add(joinFields.del);
        this.fromPanel.add(joinFields.from);
        this.relationPanel.add(joinFields.relation);
        this.toPanel.add(joinFields.to);
        this.joinsPanel.invalidate();
        this.pack();
    }

    protected void deleteSelectedJoins() {
        ArrayList arrayList = (ArrayList)this.joinFieldsList.clone();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            JoinFields joinFields = (JoinFields)iterator.next();
            if (!joinFields.del.isSelected()) continue;
            this.joinFieldsList.remove(joinFields);
            this.delCheckBoxPanel.remove(joinFields.del);
            this.fromPanel.remove(joinFields.from);
            this.relationPanel.remove(joinFields.relation);
            this.toPanel.remove(joinFields.to);
        }
        this.joinsPanel.invalidate();
        this.pack();
    }

    protected void doSave() {
        ArrayList<Join> arrayList = new ArrayList<Join>();
        Object object = this.joinFieldsList.iterator();
        while (object.hasNext()) {
            JoinFields joinFields = (JoinFields)object.next();
            Column column = this.columnFromDropdown(joinFields.from);
            String string = (String)joinFields.relation.getSelectedItem();
            Column column2 = this.columnFromDropdown(joinFields.to);
            arrayList.add(new Join(column, string, column2));
        }
        object = new TableJoinCommand(this.query, arrayList);
        ((TableJoinCommand)object).perform();
        this.commands.add((Command)object);
    }

    protected Column columnFromDropdown(JComboBox jComboBox) {
        String string = (String)jComboBox.getSelectedItem();
        return this.report.findColumn(string);
    }

    protected void doRevert() {
        this.emptyJoinsPanel();
        this.fillJoinsPanel();
        this.joinsPanel.invalidate();
        this.pack();
    }

    static class JoinFields {
        Join join;
        JCheckBox del;
        JComboBox from;
        JComboBox relation;
        JComboBox to;

        JoinFields(Join join, DataSource dataSource) {
            this.join = join;
            this.del = new JCheckBox();
            this.from = this.buildColDropdown(join == null ? null : join.getFrom(), dataSource);
            this.relation = this.buildRelDropdown(join == null ? null : join.getRelation());
            this.to = this.buildColDropdown(join == null ? null : join.getTo(), dataSource);
        }

        protected JComboBox buildColDropdown(Column column, DataSource dataSource) {
            JComboBox<String> jComboBox = new JComboBox<String>();
            Iterator iterator = dataSource.columnsInTablesUsedInReport();
            while (iterator.hasNext()) {
                Column column2 = (Column)iterator.next();
                jComboBox.addItem(column2.fullName());
                if (column == null || !column.equals(column2)) continue;
                jComboBox.setSelectedItem(column2.fullName());
            }
            return jComboBox;
        }

        protected JComboBox buildRelDropdown(String string) {
            JComboBox<String> jComboBox = new JComboBox<String>(Join.RELATIONS);
            if (string != null) {
                jComboBox.setSelectedItem(string);
            }
            return jComboBox;
        }
    }

    static class RevertInfo {
        ArrayList joins = new ArrayList();

        RevertInfo(Query query) {
            Iterator iterator = query.joins();
            while (iterator.hasNext()) {
                Join join = (Join)iterator.next();
                this.joins.add(join.clone());
            }
        }
    }
}

